# -*- coding: utf-8 -*-
"""

MPFS
CORE

Константы пользователя

"""

import os

# https://st.yandex-team.ru/CHEMODAN-25676#1439375382000
from mpfs.config import settings as _settings
import mpfs.engine.process


SYSTEM_ATTACH_SYS_FOLDERS = _settings.system['attach_sys_folders']


'''
Базовые настройки и системные уиды
'''
SHARE_UID = mpfs.engine.process.share_user()
PUBLIC_UID = '0'


# Areas
DISK_AREA = 'disk'
DISK_AREA_PATH = '/disk'
HIDDEN_AREA = 'hidden'
HIDDEN_AREA_PATH = '/hidden'
TRASH_AREA = 'trash'
TRASH_AREA_PATH = '/trash'
ATTACH_AREA = 'attach'
ATTACH_AREA_PATH = '/attach'
PHOTOUNLIM_AREA = 'photounlim'
PHOTOUNLIM_AREA_PATH = '/photounlim'
PHOTOSTREAM_AREA = 'photostream'
PHOTOSTREAM_AREA_PATH = '/photostream'
ADDITIONAL_AREA = 'additional'
ADDITIONAL_AREA_PATH = '/additional'
NOTES_AREA = 'notes'
NOTES_AREA_PATH = '/notes'
CLIENT_AREA = 'client'
CLIENT_AREA_PATH = '/client'
LNAROD_AREA = 'lnarod'
LNAROD_AREA_PATH = '/lnarod'


'''
Системные домены, папки, файлы
'''
REQUIRED_CONTENT_FOLDERS = (
    '/disk',
)

REQUIRED_TRASH_FOLDERS = (
    '/trash',
)

REQUIRED_FOLDERS_IN_HIDDEN = (
    '/hidden',
)

REQUIRED_ATTACH_FOLDERS = (
    '/attach',
)

REQUIRED_CLIENT_FOLDERS = (
    '/client',
)

# ((id, data), ...)
REQUIRED_DISK_INFO_FILES = (
    ('/total_size', 0),
    ('/trash_size', 0),
    ('/limit', _settings.services['disk']['default_limit'])
)

YATEAM_DIR_PATH = '/disk/Yandex Team (NDA)'

DEFAULT_SPACE_LIMIT = _settings.services['disk']['default_limit']

# Language Code: Country Code
# Example: http://whatsmyuseragent.com/Locale/uk-UA
SUPPORTED_LOCALES = {
    'ru': 'RU',
    'en': 'US',
    'tr': 'TR',
    'uk': 'UA'
}
DEFAULT_LOCALE = _settings.user['default_locale']


PREDEFINED_CONTENT_FOLDERS = {
    'ru': (
        u'/disk/Документы',
        u'/disk/Музыка',
    ),
    'en': (
        u'/disk/Documents',
        u'/disk/Music',
    ),
    'tr': (
        u'/disk/Belgeler',
        u'/disk/Müzik',
    ),
    'uk': (
        u'/disk/Документи',
        u'/disk/Музика',
    ),
}

PREDEFINED_CONTENT_FILES = {
    'ru': {
        '/share/doc/readme.pdf': u'/disk/Добро Пожаловать.pdf',
        u'/share/music/Мои Ракеты Вверх - Flow.mp3': u'/disk/Музыка/Мои Ракеты Вверх - Flow.mp3',
        '/share/img/wall_ru.jpg' : u'/disk/Обои для рабочего стола.jpg',
    },
    'en': {
        '/share/doc/readme_en.pdf': u'/disk/Welcome.pdf',
        u'/share/music/Мои Ракеты Вверх - Flow.mp3': u'/disk/Music/My Rockets Up - Flow.mp3',
        '/share/img/wall_en.jpg' : u'/disk/Disk Wallpaper.jpg',
    },
    'tr': {
        '/share/doc/readme_tr.pdf': u'/disk/Hoş geldiniz.pdf',
        '/share/video/video_tr.mov': u'/disk/Disk Dünyası.mov',
        '/share/img/wall_tr.jpg' : u'/disk/Disk Masaüstü Resmi.jpg',
    },
    'uk': {
        '/share/doc/readme_uk.pdf': u'/disk/Ласкаво Просимо.pdf',
        u'/share/music/Мои Ракеты Вверх - Flow.mp3': u'/disk/Музика/Мои Ракеты Вверх - Flow.mp3',
        '/share/img/wall_ru.jpg' : u'/disk/Шпалери для робочого столу.jpg',
    }
}

'''
PREDEFINED_CONTENT_FOLDERS_2014 = {
    'ru': (
        u'/disk/Музыка',
    ),
    'en': (
        u'/disk/Music',
    ),
    'tr': (
        u'/disk/Müzik',
    ),
    'uk': (
        u'/disk/Музика',
    ),
}
'''
PREDEFINED_CONTENT_FOLDERS_2014 = {
    'ru': [],
    'en': [],
    'tr': [],
    'uk': [],
}

PREDEFINED_CONTENT_FILES_2014 = {
    'ru': {
        #u'/share/music/2014_track_1.mp3': u'/disk/Музыка/01. The Jumping Cats - Thank You, Ronnie!.mp3',
        #u'/share/music/2014_track_2.mp3': u'/disk/Музыка/02. The Jumping Cats - Never Mind.mp3',
        #u'/share/music/2014_track_3.mp3': u'/disk/Музыка/03. The Jumping Cats - Crocodile Goes For Porto.mp3',
        #u'/share/music/2014_track_4.mp3': u'/disk/Музыка/04. The Jumping Cats - Waiting For A Call.mp3',
        #u'/share/music/2014_track_5.mp3': u'/disk/Музыка/05. The Jumping Cats - Unlisted Blues.mp3',
        u'/share/img/2014_spb.jpg' : u'/disk/Санкт-Петербург.jpg',
        u'/share/img/2014_moscow.jpg' : u'/disk/Москва.jpg',
        u'/share/img/2014_bears.jpg' : u'/disk/Мишки.jpg',
        u'/share/img/2014_sea.jpg' : u'/disk/Море.jpg',
        u'/share/img/2014_mountains.jpg' : u'/disk/Горы.jpg',
        u'/share/img/2014_winter.jpg' : u'/disk/Зима.jpg',
        u'/share/video/2014_breadcrumbs_ru.mp4': u'/disk/Хлебные крошки.mp4',
    },
    'en': {
        #u'/share/music/2014_track_1.mp3': u'/disk/Music/01. The Jumping Cats - Thank You, Ronnie!.mp3',
        #u'/share/music/2014_track_2.mp3': u'/disk/Music/02. The Jumping Cats - Never Mind.mp3',
        #u'/share/music/2014_track_3.mp3': u'/disk/Music/03. The Jumping Cats - Crocodile Goes For Porto.mp3',
        #u'/share/music/2014_track_4.mp3': u'/disk/Music/04. The Jumping Cats - Waiting For A Call.mp3',
        #u'/share/music/2014_track_5.mp3': u'/disk/Music/05. The Jumping Cats - Unlisted Blues.mp3',
        u'/share/img/2014_spb.jpg' : u'/disk/St. Petersburg.jpg',
        u'/share/img/2014_moscow.jpg' : u'/disk/Moscow.jpg',
        u'/share/img/2014_bears.jpg' : u'/disk/Bears.jpg',
        u'/share/img/2014_sea.jpg' : u'/disk/Sea.jpg',
        u'/share/img/2014_mountains.jpg' : u'/disk/Mountains.jpg',
        u'/share/img/2014_winter.jpg' : u'/disk/Winter.jpg',
    },
    'tr': {
        #u'/share/music/2014_track_1.mp3': u'/disk/Müzik/01. The Jumping Cats - Thank You, Ronnie!.mp3',
        #u'/share/music/2014_track_2.mp3': u'/disk/Müzik/02. The Jumping Cats - Never Mind.mp3',
        #u'/share/music/2014_track_3.mp3': u'/disk/Müzik/03. The Jumping Cats - Crocodile Goes For Porto.mp3',
        #u'/share/music/2014_track_4.mp3': u'/disk/Müzik/04. The Jumping Cats - Waiting For A Call.mp3',
        #u'/share/music/2014_track_5.mp3': u'/disk/Müzik/05. The Jumping Cats - Unlisted Blues.mp3',
        u'/share/img/2014_spb.jpg' : u'/disk/Sankt-Peterburg.jpg',
        u'/share/img/2014_moscow.jpg' : u'/disk/Moskova.jpg',
        u'/share/img/2014_bears.jpg' : u'/disk/Ayıcıklar.jpg',
        u'/share/img/2014_sea.jpg' : u'/disk/Deniz.jpg',
        u'/share/img/2014_mountains.jpg' : u'/disk/Dağlar.jpg',
        u'/share/img/2014_winter.jpg' : u'/disk/Kış.jpg',
    },
    'uk': {
        #u'/share/music/2014_track_1.mp3': u'/disk/Музика/01. The Jumping Cats - Thank You, Ronnie!.mp3',
        #u'/share/music/2014_track_2.mp3': u'/disk/Музика/02. The Jumping Cats - Never Mind.mp3',
        #u'/share/music/2014_track_3.mp3': u'/disk/Музика/03. The Jumping Cats - Crocodile Goes For Porto.mp3',
        #u'/share/music/2014_track_4.mp3': u'/disk/Музика/04. The Jumping Cats - Waiting For A Call.mp3',
        #u'/share/music/2014_track_5.mp3': u'/disk/Музика/05. The Jumping Cats - Unlisted Blues.mp3',
        u'/share/img/2014_spb.jpg' : u'/disk/Санкт-Петербург.jpg',
        u'/share/img/2014_moscow.jpg' : u'/disk/Москва.jpg',
        u'/share/img/2014_bears.jpg' : u'/disk/Ведмежата.jpg',
        u'/share/img/2014_sea.jpg' : u'/disk/Море.jpg',
        u'/share/img/2014_mountains.jpg' : u'/disk/Гори.jpg',
        u'/share/img/2014_winter.jpg' : u'/disk/Зима.jpg',
        u'/share/video/2014_breadcrumbs_uk.mp4': u'/disk/Хлібні крихти.mp4',
    }
}


class DEFAULT_FOLDERS_NAMES:
    ATTACH = 'attach'


DEFAULT_FOLDERS = {
    DEFAULT_FOLDERS_NAMES.ATTACH: {
        'ru':  u'/disk/Почтовые вложения',
        'en':  u'/disk/Mail attachments',
        'tr':  u'/disk/E-posta ekleri',
        'uk':  u'/disk/Поштові вкладення',
        'ua':  u'/disk/Поштові вкладення',
    },
    'downloads': {
        'ru': u'/disk/Загрузки/',
        'en': u'/disk/Downloads/',
        'tr': u'/disk/Downloads/',
        'uk': u'/disk/Завантаження/',
        'ua': u'/disk/Завантаження/',
    },
    'photostream': {
        'ru': u'/disk/Фотокамера/',
        'en': u'/disk/Camera Uploads/',
        'tr': u'/disk/Kameradan yüklenenler/',
        'uk': u'/disk/Фотокамера/',
        'ua': u'/disk/Фотокамера/',
    },
    'fotki': {
        'ru': u'/disk/Яндекс.Фотки/',
        'en': u'/disk/Yandex.Fotki/',
        'tr': u'/disk/Yandex.Foto/',
        'uk': u'/disk/Яндекс.Фотки/',
        'ua': u'/disk/Яндекс.Фотки/',
    },
    'screenshots': {
        'ru': u'/disk/Скриншоты/',
        'en': u'/disk/Screenshots/',
        'tr': u'/disk/Ekran görüntüleri/',
        'uk': u'/disk/Скриншоти/',
        'ua': u'/disk/Скриншоти/',
    },
    'social': {
        'ru': u'/disk/Социальные сети/',
        'en': u'/disk/Social networks/',
        'tr': u'/disk/Sosyal ağlar/',
        'uk': u'/disk/Соціальні мережі/',
        'ua': u'/disk/Соціальні мережі/',
    },
    'applications': {
        'ru': u'/disk/Приложения',
        'en': u'/disk/Applications',
        'tr': u'/disk/Uygulamalar',
        'uk': u'/disk/Додатки',
        'ua': u'/disk/Додатки',
    },
    'yabooks': {
        'ru': u'/disk/Яндекс.Книги',
        'en': u'/disk/Yandex.Books',
        'tr': u'/disk/Yandex.Kitaplar',
        'uk': u'/disk/Яндекс.Книжки',
        'ua': u'/disk/Яндекс.Книжки',
    },
    'yateamnda': {
        'ru': YATEAM_DIR_PATH,
        'en': YATEAM_DIR_PATH,
        'tr': YATEAM_DIR_PATH,
        'uk': YATEAM_DIR_PATH,
        'ua': YATEAM_DIR_PATH,
    },
    'yafotki': {
        'ru':  '/attach/YaFotki',
        'en':  '/attach/YaFotki',
        'tr':  '/attach/YaFotki',
        'uk':  '/attach/YaFotki',
        'ua':  '/attach/YaFotki',
    },
    'scans': {
        'ru':  u'/disk/Сканы',
        'en':  u'/disk/Scans',
        'tr':  u'/disk/Tarananlar',
        'uk':  u'/disk/Скани',
        'ua':  u'/disk/Скани',
    }
}


PUSH_TRANSLATIONS = {
    'share_invite_new': {
        'ru': u'%(owner)s приглашает Вас в папку «%(folder)s»',
        'uk': u'%(owner)s приглашает Вас в папку «%(folder)s»',  # same as ru
        'tr': u'%(owner)s adlı kullanıcı, sizi şu klasörü görmeniz için davet ediyor: "%(folder)s"',
        'en': u'%(owner)s would like to share their "%(folder)s" folder with you',
    },
    'space_is_low': {
        'ru': u'Место на Диске заканчивается (осталось %(free)s МБ)',
        'uk': u'Місце на Диску закінчується (залишилося %(free)s МБ)',
        'tr': u'Disk dolmak üzere (kalan alan %(free)s Mb)',
        'en': u'Yandex.Disk is running low on storage space (%(free)s Mb remaining)',
    },
    'space_is_full': {
        'ru': u'Место на Диске закончилось',
        'uk': u'Місце на Диску закінчилося',
        'tr': u'Disk\'te boş alan kalmadı',
        'en': u'Yandex.Disk has run out of space',
    }
}

# Добавляем скрытые системные папки в пространство `/attach`
for attach_sys_folder in SYSTEM_ATTACH_SYS_FOLDERS:
    path = u'/attach/%s' % attach_sys_folder
    DEFAULT_FOLDERS[attach_sys_folder] = {l: path for l in ['ru', 'en', 'tr', 'uk', 'ua']}


SOCIAL_PROVIDERS_DIRS = {
    'vkontakte': {
        'ru': u'ВКонтакте',
        'en': u'VK',
        'tr': u'VK',
        'uk': u'ВКонтакте',
        'ua': u'ВКонтакте',
    },
    'facebook': {
        'ru': u'Facebook',
        'en': u'Facebook',
        'tr': u'Facebook',
        'uk': u'Facebook',
        'ua': u'Facebook',
    },
    'mailru': {
        'ru': u'Мой Мир',
        'en': u'Мой Мир',
        'tr': u'Мой Мир',
        'uk': u'Мой Мир',
        'ua': u'Мой Мир',
    },
    'odnoklassniki': {
        'ru': u'Одноклассники',
        'en': u'Одноклассники',
        'tr': u'Одноклассники',
        'uk': u'Одноклассники',
        'ua': u'Одноклассники',
    },
    'google': {
        'ru': u'Google+',
        'en': u'Google+',
        'tr': u'Google+',
        'uk': u'Google+',
        'ua': u'Google+',
    },
    'instagram': {
        'ru': u'Instagram',
        'en': u'Instagram',
        'tr': u'Instagram',
        'uk': u'Instagram',
        'ua': u'Instagram',
    }
}


# Добавляем папки социальных сетей в локализованные пространства '/disk/Social networks/'
for social_network_folder_type in SOCIAL_PROVIDERS_DIRS:
    DEFAULT_FOLDERS[social_network_folder_type] = {
        locale: os.path.join(
            DEFAULT_FOLDERS['social'][locale],
            SOCIAL_PROVIDERS_DIRS[social_network_folder_type][locale]
        ) for locale in SUPPORTED_LOCALES
    }


PHOTOS_OF_ME_LOCALIZED = {
    'ru': u'Фото со мной',
    'en': u'Photos of me',
    'tr': u'Benimle olan fotoğraflar',
    'uk': u'Фото зі мною',
    'ua': u'Фото зі мною',
}

# https://st.yandex-team.ru/TRANSLATE-27900
FAVORITES_ALBUM_NAMES = {
    'ru': u'Избранное',
    'en': u'Favorites',
    'tr': u'Seçilenler',
    'uk': u'Вибрані',
}

# https://st.yandex-team.ru/CHEMODAN-56216
NY_2018_ALBUM_NAMES = {
    'ru': u'2018 год в фотографиях',
    'en': u'2018 in photos',
    'tr': u'Fotoğraftaki 2018',
    'uk': u'2018 рік у фотографіях',
    'ua': u'2018 рік у фотографіях',
}

DEFAULT_OFFICE_FILE_NAMES = {
    'docx': {
        'ru': u'Документ',
        'en': u'Document',
        'tr': u'Belgesi',
        'uk': u'Документ',
    },
    'xlsx': {
        'ru': u'Таблица',
        'en': u'Spreadsheet',
        'tr': u'Tablosu',
        'uk': u'Таблиця',
    },
    'pptx': {
        'ru': u'Презентация',
        'en': u'Presentation',
        'tr': u'Sunumu',
        'uk': u'Презентація',
    },
}

VERSIONING_SAVE_VERSION_SUFFIX = {
    'ru': u' (версия от %s)',
    'en': u' (version from %s)',
    'tr': u' (%s sürümü)',
    'uk': u' (версія від %s)',
}

OFFICE_SERVICE_BRAND_NAME = {
    'ru': u'Яндекс.Диск',
    'en': u'Yandex.Disk',
    'tr': u'Yandex.Disk',
    'uk': u'Яндекс.Диск',
}

OFFICE_SERVICE_FOLDER_NAME = {
    'ru': u'К сохраненному файлу',
    'en': u'Back to folder',
    'tr': u'Kaydedilmiş dosyaya git',
    'uk': u'До збереженого файлу'
}

PHOTOS_OF_ME_MAILRU = u'Меня отметили на фото'

ODNOKLASSNIKI_PERSONAL_PHOTOS = {
    'ru': u'Личные фотографии',
    'en': u'Personal photos',
    'tr': u'Personal photos',       # Odnoklassniki doesn't support turkish
    'uk': u'Приватні фотографії',
    'ua': u'Приватні фотографії',
}

VK_WALL_PHOTOS = {
    'ru': u'Фотографии на моей стене',
    'en': u'My wall photos',
    'tr': u'Duvarımdaki fotoğraflar',
    'uk': u'Фотографії на моїй стіні',
    'ua': u'Фотографії на моїй стіні',
}

VK_PROFILE_PHOTOS = {
    'ru': u'Фотографии с моей страницы',
    'en': u'My profile photos',
    'tr': u'Benim sayfamdan fotoğraflar',
    'uk': u'Фотографії з моєї сторінки',
    'ua': u'Фотографії з моєї сторінки',
}

VK_SAVED_PHOTOS = {
    'ru': u'Сохранённые фотографии',
    'en': u'Saved photos',
    'tr': u'Kayıtlı Fotoğraflar',
    'uk': u'Збережені фотографії',
    'ua': u'Збережені фотографії',
}

MAILRU_PROFILE_PHOTOS = u'Фото со мной'

'''
Инвайты
'''
INVITES_USER_BONUS = _settings.user['invites']['user_bonus']
INVITES_REFERRAL_BONUS = _settings.user['invites']['referral_bonus']
INVITES_REFERRAL_POOL = _settings.user['invites']['referral_pool']

'''
Состояния и увеличения места
'''
DEFAULT_NAMESPACE = 'global'
DEFAULT_PROJECT   = 'disk'

IS_PAID_WITHOUT_PS_BILLING = 'IS_PAID_WITHOUT_PS_BILLING'

SET_STATES_SETTINGS = {
    DEFAULT_PROJECT: {
        'states': {
            DEFAULT_NAMESPACE: (
                'desktop_installed',
                'mobile_installed',
                'webdav_used',
                'promo_shared',
                'file_uploaded',
                'yandex_staff',
                'passport_split',
                'turkey_proje_y',
                'yandex_shad',
                'yandex_browser',
                'photostream_used',
                'turkey_panorama',
                'yandex_ege',
                'blat_250',
                'ny_2014',
            )
        }
    }
}

REMOVE_STATES_SETTINGS = {
    DEFAULT_PROJECT: {
        'states': {
            DEFAULT_NAMESPACE: (
                'file_uploaded',
                'desktop_installed',
                'mobile_installed',
                'webdav_used',
                'yandex_staff',
                'passport_split',
                'turkey_proje_y',
                'yandex_shad',
                'yandex_browser',
                'photostream_used',
                'turkey_panorama',
                'yandex_ege',
                'blat_250',
                'ny_2014',
            )
        }
    }
}

DENY_MANUAL_STATE_SETTINGS = {
    DEFAULT_PROJECT: {
        'states': {
            DEFAULT_NAMESPACE: (
                'desktop_installed',
            )
        }
    }
}

SPACE_INCREMENTS = {}
INCREMENT_REASONS = {}
for reason, reason_value in _settings.extra_space.iteritems():
    SPACE_INCREMENTS[reason] = reason_value
    for state in reason_value['states']:
        INCREMENT_REASONS[state] = reason

'''
Особые турецкие значения
'''
TURKISH_BORDER_DATE = 1335906000
TURKISH_SPACE_BONUS = 1073741824
TURKISH_REASON = 'turkish'


'''
Константы хешей пустого файла
'''
EMPTY_FILE_HASH_MD5 = 'd41d8cd98f00b204e9800998ecf8427e'
EMPTY_FILE_HASH_SHA256 = 'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855'

'''
Константы шаблонов для ФОС
'''
TELEMOST_FOS_SUBJECT_TEMPLATE = "%(os_version)s - %(app_version)s - %(fos_subject)s"
TELEMOST_FOS_BODY_TEMPLATE = """
%(support_text)s

-----
Login: %(login)s
UID: %(uid)s
App Version: %(app_version)s
OS Version: %(os_version)s
%(debug_info)s
""".strip()

MSO_USAGE_KEY = '/last_mso_usage'
MSO_USAGE_FIELD = 'last_mso_usage'

HAS_SHARED_FOLDERS_FIELD = 'has_shared_folders'
HAS_SHARED_FOLDERS_KEY = '/%s' % HAS_SHARED_FOLDERS_FIELD
