# -*- coding: utf-8 -*-
"""

MPFS
CORE

Работа с устройствами пользователя

"""
import time
import copy
from collections import namedtuple

import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.user.settings import UserKeyValueData

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

USER_MAX_DEVICE_COUNT = settings.user['max_device_count']
USER_ENABLE_REMOVE_EXTRA_DEVICES = settings.user['enable_remove_extra_devices']


class Devices(UserKeyValueData):
    '''
    Класс подключенных устройств пользователя
    '''
    type = 'devices'
    _DeviceInfo = namedtuple('_DeviceInfo', ['type', 'id', 'info'])

    def _device_count(self):
        return sum((len(x) for x in self.list_all().values()))

    def install(self, type, id, params={}):
        # Очищаем информацию об устройствах, если их слишком много
        if USER_ENABLE_REMOVE_EXTRA_DEVICES and self._device_count() >= USER_MAX_DEVICE_COUNT:
            self.clear()

        info = copy.copy(params)
        info['reg_time'] = int(time.time())
        self.set(id, info, type)

    def uninstall(self, type, id):
        self.remove(id, type)

    def match(self, id, type=None, info=None):
        if type:
            devdict = {type: self.list(type)}
        else:
            devdict = self.list_all()

        for type, devices in devdict.iteritems():
            for item, stored_info in devices.iteritems():
                if item == id:
                    stored_copy = copy.copy(stored_info)
                    stored_copy.pop('reg_time')
                    if (not info) or (info and stored_copy == info):
                        return True

        return False


def process_device_installation(uid, _type, _id, info):
    '''
    Центральный метод обработки инсталляции устройства
    '''
    devices = Devices(uid)

    if not devices.match(_id, _type, info):
        devices.install(_type, _id, info)
