# -*- coding: utf-8 -*-
from mpfs.core.event_dispatcher.events import Event


class SpaceEvent(Event):
    """Базовый класс событий изменения квоты дискового пространства"""
    required_fields = (('uid', basestring),
                       ('old_limit', (int, long)),
                       ('new_limit', (int, long)),
                       ('reason', (basestring, type(None)),))


class EnlargeSpaceEvent(SpaceEvent):
    """Событие увеличения лимита дискового пространства"""


class ReduceSpaceEvent(SpaceEvent):
    """Событие уменьшения лимита дискового пространства"""
