# -*- coding: utf-8 -*-
"""

MPFS
CORE

Пользователь перенесенного Народа

"""
from itertools import izip, repeat

import traceback

import mpfs.engine.process
from mpfs.core.user.constants import *
from mpfs.core.user.base import CommonUser
from mpfs.core.metastorage.control import lnarod, link_data

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

NAROD_REQUIRED_USER_DOMAINS = (
    lnarod,
    link_data,
)

NAROD_REQUIRED_FOLDERS = list(izip(('/lnarod',), repeat(lnarod, 1)))

class NarodUser(CommonUser):
    
    required_user_domains = NAROD_REQUIRED_USER_DOMAINS
    required_folders = NAROD_REQUIRED_FOLDERS
    required_files = []
    predefined_content_folders = {}
    predefined_content_files = {}
    subscribe_passport = False
    type = 'narod'
        
    @classmethod
    def Create(cls, uid, **params):
        try:
            cls._create_domains(uid)
            cls._create_system_folders(uid)            
        except Exception:
            log.warning('narod infrastructure creation failed, rollbacking %s' % uid)
            error_log.error(traceback.format_exc())
            raise

    @classmethod
    def NeedInit(cls, uid, project, *args, **kwargs):
        return super(NarodUser, cls).NeedInit(uid, project, db=True, data=True, sid=False)
