# -*- coding: utf-8 -*-
from mpfs.config import settings

FEATURE_TOGGLES_B2B_IGNORE_SHARED_FOLDER_IN_QUOTA = settings.feature_toggles['b2b_ignore_shared_folder_in_quota']
FEATURE_TOGGLES_IGNORE_SHARED_FOLDER_IN_QUOTA = settings.feature_toggles['ignore_shared_folder_in_quota']
FEATURE_TOGGLES_IGNORE_SHARED_FOLDER_IN_QUOTA_FOR_ALL = \
    settings.feature_toggles['ignore_shared_folder_in_quota_for_all']
FEATURE_TOGGLES_CORRECT_SPACE_CHECKS_FOR_SHARED_FOLDERS_DRY_RUN = \
    settings.feature_toggles['correct_space_checks_for_shared_folders_dry_run']
FEATURE_TOGGLES_CORRECT_SPACE_CHECKS_FOR_SHARED_FOLDERS_DRY_RUN_BLACK_LIST_UIDS = \
    settings.feature_toggles['correct_space_checks_for_shared_folders_dry_run_black_list_uids']


def ignores_shared_folders_space(uid=None, user=None):
    """Определяет нужно ли игнорировать размер расшаренных пользователю ОП.

    Нужно передавать либо uid, либо готового пользователя (`mpfs.core.user.base.User`).
    """
    if FEATURE_TOGGLES_IGNORE_SHARED_FOLDER_IN_QUOTA_FOR_ALL:
        return True

    if user is None:
        # иначе получается циклический импорт
        from mpfs.core.user.base import User
        user = User(uid)

    ignore_shared_folder = False
    if FEATURE_TOGGLES_B2B_IGNORE_SHARED_FOLDER_IN_QUOTA:
        ignore_shared_folder = user.is_b2b()
    if FEATURE_TOGGLES_IGNORE_SHARED_FOLDER_IN_QUOTA:
        if user.is_yateam():
            ignore_shared_folder = True

    return ignore_shared_folder


def is_correct_space_checks_in_dry_mode_for(uid):
    return (FEATURE_TOGGLES_CORRECT_SPACE_CHECKS_FOR_SHARED_FOLDERS_DRY_RUN and
            uid not in FEATURE_TOGGLES_CORRECT_SPACE_CHECKS_FOR_SHARED_FOLDERS_DRY_RUN_BLACK_LIST_UIDS)
