# -*- coding: utf-8 -*-
"""

MPFS
CORE

Пользователь Yandex.Shell Settings

"""
from itertools import izip, repeat

import mpfs.engine.process

from mpfs.core.user.constants import *
from mpfs.core.user.common import CommonUser
from mpfs.core.user.attach import AttachUser
from mpfs.core.metastorage.control import misc, link_data

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

YASHELL_REQUIRED_USER_DOMAINS =(
    misc,
    link_data,
)

YASHELL_REQUIRED_FOLDERS = list(izip(('/settings',), repeat(misc, 1)))

class YaShellSettingsUser(AttachUser, CommonUser):
    
    required_user_domains = YASHELL_REQUIRED_USER_DOMAINS
    required_folders = YASHELL_REQUIRED_FOLDERS
    required_files = []
    predefined_content_folders = {}
    predefined_content_files = {}
    subscribe_passport = False
    type = 'settings'
    
    @classmethod
    def NeedInit(cls, uid, project, *args, **kwargs):
        return super(YaShellSettingsUser, cls).NeedInit(uid, project, db=True, data=True, sid=False)

