#!/usr/bin/env python
# coding: utf8
import click

from mpfs.config import settings

SHARPEI_ERROR_THRESHOLD = settings.user_activity_info['sharpei_errors_threshold']
MISSING_UIDS_THRESHOLD = settings.user_activity_info['missing_uids_threshold']


@click.group()
def user_activity_info():
    pass


@click.command('load_from_yt', help='Aggregate user activity info from YT and put to DB')
@click.option('--date', type=click.STRING,
              help='Date or dates range for info aggregations (e.g. 2018-01-01 or 2018-01-01..2018-02-11)')
@click.option('--table', type=click.STRING, help='Read data from specified table')
@click.option('--dry-run', is_flag=True, help='Dry run mode')
@click.option('--manual', is_flag=True, help='Ignore "job_enabled" flag in settings')
@click.option('--provide-discounts', is_flag=True, help='Provide discounts to come back users')
def load_from_yt(date, table, dry_run, manual, provide_discounts):
    if not settings.user_activity_info['job_enabled'] and not manual:
        print 'Job disabled by settings, exit'
        return

    import mpfs.engine.process
    try:
        mpfs.engine.process.setup_admin_script()
    except RuntimeError:
        pass

    import yt_loader
    sharpei_errors_count, missing_uids_count = yt_loader.load(date, table, dry_run, provide_discounts=provide_discounts)

    if sharpei_errors_count > SHARPEI_ERROR_THRESHOLD or missing_uids_count > MISSING_UIDS_THRESHOLD:
        raise RuntimeError(
            'Errors threshold exceeded (sharpei_errors_count: %s, missing_uids_count: %s)' %
            (sharpei_errors_count, missing_uids_count))


user_activity_info.add_command(load_from_yt)
