# -*- coding: utf-8 -*-
from mpfs.engine.queue2.celery import BaseTask, app
from mpfs.core.address import ResourceId
from mpfs.core.versioning.errors import VersionLinkNotFound
from mpfs.core.versioning.logic.version_manager import ResourceVersionManager
from mpfs.core.versioning.logic.version_chain import VersionChain


@app.task(base=BaseTask)
def handle_remove_versions(raw_resource_id, context=None, **kwargs):
    # Эти таски так же ставятся из djfs!
    # костыль, который позволяет передать в таск как список, так и один ресурс id
    if isinstance(raw_resource_id, basestring):
        raw_resource_ids = [raw_resource_id]
    elif isinstance(raw_resource_id, (list, tuple)):
        raw_resource_ids = raw_resource_id
    else:
        raise TypeError('Expected basestring, tuple or list. Got "%s"' % raw_resource_id)

    for raw_resource_id in raw_resource_ids:
        resource_id = ResourceId.parse(raw_resource_id)
        ResourceVersionManager.remove_versions(resource_id)


@app.task(base=BaseTask)
def handle_truncate_versions(raw_resource_id, truncate_limit, context=None, **kwargs):
    resource_id = ResourceId.parse(raw_resource_id)
    try:
        version_chain = VersionChain.get_by_resource_id(resource_id)
    except VersionLinkNotFound:
        return
    version_chain.truncate(truncate_limit)
