# -*- coding: utf-8 -*-
import mpfs.core.wake_up.logic as logic
import mpfs.engine.process
from mpfs.core.wake_up.session import SessionId
from mpfs.core.metastorage.decorators import user_exists_and_not_blocked
from mpfs.common.errors import BadRequestError

error_log = mpfs.engine.process.get_error_log()


@user_exists_and_not_blocked
def wake_up_push_start(req):
    operation = logic.wake_up_push_start(req.uid, req.device_id, req.interval)
    return {
        'oid': operation.id,
        'type': operation.type,
        'at_version': operation.at_version,
        'session_id': operation.session_id,
    }


def wake_up_push_stop(req):
    try:
        session_id = SessionId.parse(req.session_id)
    except ValueError:
        error_log.error('Invalid session_id provided: %s' % req.session_id)
        raise BadRequestError()
    return logic.wake_up_push_stop(session_id)
