# -*- coding: utf-8 -*-
from mpfs.core.operations import manager


def wake_up_push_start(uid, device_id, interval):
    """
    Используется механизм uniq_id, если операция для связки uid и device_id уже есть,
    то новая создаваться не будет, а вернется существущая.
    :param uid: uid пользователя
    :param device_id: идентификатор устройства вида DFBDE026-32ED-4S5A-9H9F-D1R497E64006
    :param interval: время в секундах между пушами
    :return:
    """
    operation = manager.create_operation(uid, 'wake_up', 'send_push', {'device_id': device_id, 'interval': interval})
    operation.update_start_ts()
    return operation


def wake_up_push_stop(session_id):
    uid = session_id.uid
    oid = session_id.oid
    operation = manager.get_operation(uid, oid)
    operation.set_completed()
