# -*- coding: utf-8 -*-
from mpfs.common import errors


class SessionId(object):
    SEP = ':'
    OPERATION_ID_LEN = 64

    def __init__(self, uid, oid):
        if not (uid and oid):
            raise errors.AddressError('`uid` and `oid` must be specified. Got uid: "%s", oid: "%s"' % (uid, oid))
        if len(oid) != self.OPERATION_ID_LEN:
            raise ValueError('"oid" part of session_id must be %s characters long' % self.OPERATION_ID_LEN)
        self.uid = uid
        self.oid = oid

    @classmethod
    def parse(cls, raw_session_id):
        """
        Создать объект SessionId из строкового представления

        :param str raw_session_id: Строка вида <uid>:<oid>.
        """
        uid, oid = raw_session_id.split(cls.SEP, 1)
        return cls(uid, oid)

    def serialize(self):
        """Вернуть строковое представление :class:`~SessionId`.

        :rtype: str | unicode
        """
        return '%s%s%s' % (self.uid, self.SEP, self.oid)

    def __str__(self):
        return self.serialize()

    def __repr__(self):
        return '%s(uid=%r, oid=%r)' % (self.__class__.__name__, self.uid, self.oid)
