# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.common import errors
from mpfs.common.util import from_json
from mpfs.core.user.base import User
from mpfs.core.yateam import logic


log = mpfs.engine.process.get_default_log()


def staff_user_changed_callback(req):
    """Пересинхронизировать юзера со стаффом

    Query string аргументы:
        * yateam_uid [обязательный] - YaTeam уид, к который был изменен.
    """
    logic.resync_yateam_user(req.yateam_uid)
    return {}


def staff_make_yateam_admin(req):
    """Насильно сделать юзера ятимным

    Query string аргументы:
        * uid [обязательный] - уид пользователя.
        * yateam_uid [обязательный] - YaTeam уид, соответствующий пользователю.
    """
    logic.make_yateam(req.uid, req.yateam_uid)
    return {}


def staff_reset_yateam_admin(req):
    """Насильно сделать юзера не ятимным

    Query string аргументы:
        * uid [обязательный] - уид пользователя.
    """
    logic.reset_yateam(req.uid)
    return {}


def passport_user_2fa_changed(req):
    """Обработать изменение статуса 2FA у пользователя.

    Формат:
    {
        'v': 1,
        'uid': <uid>,
        'event': 'account.changed',
        'timestamp': <unixtimestamp события>
    }

    При отключении ручка будет дергаться с event: account.otp_disabled, при включении - event: account.otp_enabled

    https://st.yandex-team.ru/PASSP-17775
    https://st.yandex-team.ru/CHEMODAN-38397
    """
    data = from_json(req.http_req.data)
    uid = str(data['uid'])
    log.info('2FA changed callback for uid ' + uid)
    try:
        user = User(uid)
        if user.is_yateam():
            logic.update_user_yateam_status_async(uid)
    except errors.StorageInitUser:
        pass
    return {"status": "ok"}
