# -*- coding: utf-8 -*-

from kazoo.exceptions import ZookeeperError
from uwsgidecorators import timer, spool

from mpfs.config import settings
from mpfs.core.zookeeper.manager import ZookeeperClientManager
from mpfs.core.zookeeper.shortcuts import write_settings_to_file
from mpfs.engine.process import get_error_log

error_log = get_error_log()


@spool
@timer(settings.zookeeper['cache']['refresh_time'])
def update_settings_cache_file(env):
    """
    Спулер, переодически записывающий настройки из зукипера в локальный файл

    http://uwsgi-docs.readthedocs.io/en/latest/Spooler.html
    """
    if settings.zookeeper['isolate_zk']:
        return
    zk_client = None
    try:
        try:
            zk_client = ZookeeperClientManager.create_client()
            zk_client.start(timeout=settings.zookeeper['connection_timeout'])
        except:
            error_log.error('Failed to connect to zookeeper', exc_info=True)
            return

        try:
            value, stats = zk_client.get(settings.zookeeper['settings_path'])
        except ZookeeperError:
            error_log.error('Failed to get settings from zookeeper, path=%s' % settings.zookeeper['settings_path'],
                            exc_info=True)
            return
        write_settings_to_file(value)
    finally:
        if zk_client:
            zk_client.stop()
            zk_client.close()
