# -*- coding: utf-8 -*-
from mpfs.core.zookeeper.shortcuts import get_checksum


# последние полученные настройки
__zookeeper_settings_latest__ = None
__zookeeper_settings_checksum_latest__ = None
# настройки, которые сейчас использует процесс (точно применённые)
__zookeeper_settings_current__ = None
__zookeeper_settings_checksum_current__ = None


def set_zookeeper_settings_latest(value):
    """Установить значение последних полученных настроек.

    Данная переменная может быть выставлена в любое время в рамках запроса, поэтому
    перед очередным запросом значение из этой переменной перекладывается в основную переменную
    (__zookeeper_settings_current__).
    Это защита от случая, когда измененные настройки прилетели в середине запроса и часть запроса
    выполнялась с одними настройками, а часть с другими."""
    global __zookeeper_settings_latest__
    __zookeeper_settings_latest__ = value
    global __zookeeper_settings_checksum_latest__
    __zookeeper_settings_checksum_latest__ = get_checksum(value)


def get_zookeeper_settings_latest():
    return __zookeeper_settings_latest__


def get_zookeeper_settings_checksum_latest():
    return __zookeeper_settings_checksum_latest__


def set_zookeeper_settings_current(value):
    global __zookeeper_settings_current__
    __zookeeper_settings_current__ = value
    global __zookeeper_settings_checksum_current__
    __zookeeper_settings_checksum_current__ = get_checksum(value)


def get_zookeeper_settings_current():
    return __zookeeper_settings_current__


def get_zookeeper_settings_checksum_current():
    return __zookeeper_settings_checksum_current__


def uwsgi_is_launched():
    try:
        import uwsgi
        return True
    except ImportError:
        return False
