# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from mpfs.config import settings
from mpfs.core.event_dispatcher.events import Event
from mpfs.core.zookeeper import env
from mpfs.core.zookeeper.shortcuts import update_settings
from mpfs.core.zookeeper.sync_primitives import settings_updated_after_fork_event
from mpfs.engine.process import get_default_log
"""
Хуки, использующиеся внутри приложения (не в точке входа).
"""


default_log = get_default_log()


class SettingsChangeEvent(Event):
    """Событие изменения настроек."""


def update_settings_in_current_worker(dispatcher=None, worker_id='celery'):
    """Обновить сеттинги в текущем воркере.

    Обновление произойдет и сигнал пошлется только в случае,
    если текущие сеттинги отличаются от предлагаемых."""

    # FIXME: Внимание!
    # FIXME: В случае использования этого кода для обновления любых настроек в среде мультитрединга или
    # FIXME: кооперативной многозадачности может быть ситуация когда часть реквеста выполнена с одними настройками,
    # FIXME: а часть с другими (При проверке доступов мы к настройкам авторизации обращаемся только 1 раз и
    # FIXME: такой ситуации вроде как быть не может, поэтому сейчас нас это устраивает).
    # FIXME: Пример: Гринлет 1 читает настройки и начинает обрабатывать запрос, делает запрос во внешний сервис и
    # FIXME: свитчит контекст. В это время приходят новые настройки, гринлет 2 применяет их в глобальную переменную,
    # FIXME: происходит возврат к гринлету 1, вуаля, у него теперь настройки не те, с которыми он начинал.
    # FIXME: В качестве идеи можно *сразу после старта* нового треда/гринлета в его local object переменную копировать
    # FIXME: последние актуальные настройки, и во всех местах они читаться должны только оттуда, то есть для каждого
    # FIXME: треда они свои. Ну или лепить костыли, где только возможно. Можно пробовать такую схему провернуть в
    # FIXME: before_request функции, где последние настройки копируются в локальную переменную и всем сообщается что
    # FIXME: надо работать с ними.

    # в тестах не будет доступна библиотека uwsgi раз
    # а два - не будет выставлен эвент после форка мастер-процесса, поэтому этот
    # участок кода тоже скипаем

    if env.uwsgi_is_launched():
        import uwsgi

    if settings.zookeeper['isolate_zk']:
        return

    if env.uwsgi_is_launched():
        settings_updated_after_fork_event.wait()

    current_settings = env.get_zookeeper_settings_current()
    current_checksum = env.get_zookeeper_settings_checksum_current()
    latest_settings = env.get_zookeeper_settings_latest()
    latest_checksum = env.get_zookeeper_settings_checksum_latest()
    if not latest_settings:
        return

    if not current_settings or current_checksum != latest_checksum:
        env.set_zookeeper_settings_current(latest_settings)

        if not settings.zookeeper['apply_new_settings']:
            return

        update_settings(latest_settings)

        if dispatcher is not None:
            dispatcher.send(SettingsChangeEvent())

        if env.uwsgi_is_launched():
            worker_id = uwsgi.worker_id()

        default_log.info('Worker %s now is using settings version %s.' % (worker_id, latest_checksum))
