# -*- coding: utf-8 -*-

"""
Примитивы синхронизации потоков, которые работают с динамическими настройками.
"""

import threading
import Queue

from mpfs.config import settings


if settings.zookeeper['async_mode']:
    # gevent
    import gevent.queue
    import gevent.event

    settings_queue = gevent.queue.Queue()
    settings_updated_after_fork_event = gevent.event.Event()
    empty_queue_exception = gevent.queue.Empty
else:
    # threading
    settings_queue = Queue.Queue()
    settings_updated_after_fork_event = threading.Event()
    empty_queue_exception = Queue.Empty
