# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from mpfs.core.zookeeper.sync_primitives import settings_queue, settings_updated_after_fork_event
from mpfs.engine.process import get_default_log, get_error_log

"""
ATTENTION! Данный модуль будет работать только внутри uwsgi процесса.
http://uwsgi-docs.readthedocs.io/en/latest/PythonDecorators.html
Его следует импортировать ТОЛЬКО в точке входа в приложение.
"""

import uwsgi
from uwsgidecorators import postfork, thread

from mpfs.core.zookeeper.shortcuts import push_new_settings_to_queue


default_log = get_default_log()
error_log = get_error_log()


@postfork
def preload_settings_and_start_zk_init():
    from mpfs.core.zookeeper.thread import preload_settings_and_start_zk_init_function
    preload_settings_and_start_zk_init_function(worker_id=uwsgi.worker_id())


@postfork
@thread
def worker_thread_settings_applier():
    """Поток который получает данные из очереди настроек и
    применяет их для переменной последних настроек.

    После первого обновления настроек он выставляет флаг, сообщающий потокам,
    что теперь можно начать обрабатывать запросы пользователей, тк мы получили правильные настройки.
    Это критически необходимо после форка воркера от мастера, тк мастер не держит
    коннект к зукиперу и у него в памяти могут быть уже 1000 лет как устаревшие настройки.
    В таком случае перед обработкой реквеста поток заблокируется в ожидании выставления этого флага.
    """
    default_log.info(
        'Settings applier thread has been started on worker %s.' % uwsgi.worker_id()
    )
    while True:
        push_new_settings_to_queue(block=True, worker_id=uwsgi.worker_id())
