# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.core.billing.dao.migrator import (
    BillingLocksMigration, BillingOrdersHistoryMigration,
    BillingOrdersMigration, BillingServiceAttributesHistoryMigration,
    BillingServiceAttributesMigration, BillingServicesHistoryMigration,
    BillingServicesMigration, BillingSubscriptionsMigration)
from mpfs.core.billing.inapp.dao.unprocessed_receipt import UnprocessedReceiptMigration
from mpfs.core.filesystem.dao.recount import RecountMigration
from mpfs.core.filesystem.dao.trash_cleaner_queue import TrashCleanerQueueMigration
from mpfs.core.office.dao.migrator import OfficeAllowedPddDomainsMigration
from mpfs.core.organizations.dao.migrator import OrganizationMigration
from mpfs.core.promo_codes.dao.migrator import (DiscountArchiveMigration, DiscountTemplateMigration,
                                                PromoCodeArchiveMigration, PromoCodeMigration)
from mpfs.core.support.dao.migrator import (SupportBlockHistoryMigration, SupportBlockedHidsMigration,
                                            SupportModerationQueueMigration, SupportMpfsMigration,
                                            SupportProhibitedCleaningUsersMigration)
from mpfs.core.social.dao.migrator import GroupsMigration, GroupInvitesMigration, GroupLinksMigration
from mpfs.dao.migration.migration import MigrationMode

default_log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class CommonMigrationManager(object):
    _migration_class_set = {
        BillingLocksMigration,
        BillingOrdersHistoryMigration,
        BillingOrdersMigration,
        BillingServiceAttributesHistoryMigration,
        BillingServiceAttributesMigration,
        BillingServicesHistoryMigration,
        BillingServicesMigration,
        BillingSubscriptionsMigration,
        DiscountArchiveMigration,
        DiscountTemplateMigration,
        GroupInvitesMigration,
        GroupLinksMigration,
        GroupsMigration,
        OfficeAllowedPddDomainsMigration,
        OrganizationMigration,
        PromoCodeArchiveMigration,
        PromoCodeMigration,
        RecountMigration,
        SupportBlockHistoryMigration,
        SupportBlockedHidsMigration,
        SupportModerationQueueMigration,
        SupportMpfsMigration,
        SupportProhibitedCleaningUsersMigration,
        TrashCleanerQueueMigration,
        UnprocessedReceiptMigration,
    }

    def __init__(self, mode=MigrationMode.REAL, on_update_callback=None):
        self.mode = mode
        self.update_callback = on_update_callback

    def _get_migrator(self, collection_name):
        for migration_class in self._migration_class_set:
            if collection_name == migration_class.dao_cls.dao_item_cls.mongo_collection_name:
                return migration_class
        return None

    def run(self, collection_name, skip=0, limit=0, validate=True, **kwargs):
        migration_class = self._get_migrator(collection_name)
        if migration_class is None:
            error_log.error("[CommonMigrationManager]: Collection unknown: %s", collection_name)
            raise KeyError("Unknown collection name")
        try:
            migrator = migration_class(mode=self.mode)
            assert migrator.run(skip=skip, limit=limit, validate=validate)
        except Exception as exc:
            error_log.error("[CommonMigrationManager]: Error occurred: %s", exc, exc_info=True)
            raise
        else:
            default_log.info('[CommonMigrationManager]: %s was migrated successfully (mode was `%s`)',
                             collection_name, self.mode)
            return 'Success'
