# -*- coding: utf-8 -*-
"""

MPFS
ENGINE

HTTP-агент

"""
import urllib
import urllib2
import time
import sys
import StringIO

from mpfs.common.util.logger import headers_to_log
from mpfs.config import settings
import mpfs.engine.process
from mpfs.engine.process import get_error_log
from mpfs.common.static.tags import GET, POST

requests_log = mpfs.engine.process.get_requests_log()

HTTP_RETRY_LIMIT = settings.system['http_retries']
NOT_LOGGED_HEADERS = settings.services['ServiceBase']['not_logged_headers']

FOLLOW_REDIRECTS_REQUEST_ATTR_NAME = 'mpfs_follow_redirects'


def _follow_redirects_manager(fn):
    """
    Декоратор управляющий автопереходом по редиректам.

    В зависимости от значения атрибута запроса `FOLLOW_REDIRECTS_REQUEST_ATTR_NAME` заставляет декорируемый метод
    не переходить автоматически по редиректам.
    """
    def follow_redirects_manager(self, req, fp, code, msg, headers):
        # Если у запроса нет спец. атрибута, то сохраням дефолтное поведение urllib2 -- автоматом идём по редиректам.
        if req and not getattr(req, FOLLOW_REDIRECTS_REQUEST_ATTR_NAME, True):
            infourl = urllib.addinfourl(fp, headers, req.get_full_url())
            infourl.status = code
            infourl.code = code
            return infourl
        else:
            return fn(self, req, fp, code, msg, headers)

    return follow_redirects_manager


class ManagedRedirectHandler(urllib2.HTTPRedirectHandler):
    @_follow_redirects_manager
    def http_error_301(self, req, fp, code, msg, headers):
        return urllib2.HTTPRedirectHandler.http_error_301(self, req, fp, code, msg, headers)

    @_follow_redirects_manager
    def http_error_302(self, req, fp, code, msg, headers):
        return urllib2.HTTPRedirectHandler.http_error_302(self, req, fp, code, msg, headers)

    @_follow_redirects_manager
    def http_error_303(self, req, fp, code, msg, headers):
        return urllib2.HTTPRedirectHandler.http_error_303(self, req, fp, code, msg, headers)

    @_follow_redirects_manager
    def http_error_307(self, req, fp, code, msg, headers):
        return urllib2.HTTPRedirectHandler.http_error_307(self, req, fp, code, msg, headers)


urllib2.install_opener(urllib2.build_opener(ManagedRedirectHandler()))


def open_url(theurl, log=None, url_data=dict(), cookie_data=dict(), timeout=5, api_err=None, pure_data=None, rais=False,
             retry=True, log_data=True, method=None, headers={}, logged_data=None, pass_crid=False, return_status=False,
             follow_redirects=True, response_patch=None, need_tvm_ticket=False, http_retries=None):
    """
        Process url
    :param theurl:
    :param log:
    :param url_data:
    :param cookie_data:
    :param timeout:
    :param api_err:
    :param pure_data:
    :param rais:
    :param retry:
    :param log_data:
    :param method:
    :param headers:
    :param logged_data:
    :param pass_crid: pass Yandex-Cloud-Request-ID
    :param return_status: Возвращать HTTP-статус вместе с телом ответа
    :param response_patch: Вместо запроса возвращает содержимое этого параметра, который содержит кортеж из 3х элементов
                           (<int: http-статус ответа>, <str: тело ответа>, <dict: заголовки ответа>).
    :param need_tvm_ticket: Нужно ли получить от TVM новый тикет или нет. False только в случае обращения к TVM, чтобы
                            избежать рекурсии
    :return:

    ..warning::
        Все значения из `url_data` фильруются как `bool(val) is False`.
        Для передачи значения `False`, например, необходимо привести его явно к строке.

    """
    e = None
    encoded_data = None
    is_error = False
    if type(theurl) == type(u''):
        theurl = theurl.encode('utf-8')
    theurl = urllib.quote(theurl, safe="%/:=&?~#+!$,;'@()*[]")

    # Process pure data...
    if pure_data:
        encoded_data = pure_data
        if type(encoded_data) == type(u''):
            encoded_data = encoded_data.encode('utf-8')

    # Or - process normal POST data
    elif len(url_data.keys()):
        options = {}
        for arg, value in url_data.iteritems():
            if value:
                if type(value) == type(u''):
                    value = value.encode('utf-8')
                options[arg] = value
        encoded_data = urllib.urlencode(options)

    # Create request
    req = urllib2.Request(theurl, encoded_data)
    setattr(req, FOLLOW_REDIRECTS_REQUEST_ATTR_NAME, follow_redirects)

    for k, v in cookie_data.iteritems():
        req.add_header('Cookie', k + '=' + v)

    # Processing headers
    for k, v in headers.iteritems():
        req.add_header(k, v)
    cloud_request_id = mpfs.engine.process.get_cloud_req_id()
    if pass_crid and cloud_request_id:
        req.add_header('Yandex-Cloud-Request-ID', cloud_request_id)

    if need_tvm_ticket:
        tvm_ticket = mpfs.engine.process.get_external_tvm_ticket()
        if tvm_ticket is None:
            tvm_ticket = mpfs.engine.process.get_tvm_ticket()
        if tvm_ticket:
            req.add_header('Ticket', tvm_ticket.value())

    # Processing method
    if method:
        req.get_method = lambda: method

    if response_patch:
        # эмулируем все переменные, так буд-то в самом деле сделали запрос
        if response_patch[0] > 299:
            e = urllib2.HTTPError(theurl, response_patch[0], '', response_patch[2].items(),
                                  StringIO.StringIO(response_patch[1]))
            is_error = True
            http_code = e.code
        else:
            http_code, result, resp_headers = response_patch
    else:
        if http_retries is None:
            http_retries_counter = xrange(HTTP_RETRY_LIMIT)
        else:
            http_retries_counter = xrange(http_retries)

        # Try to open url
        for try_count in http_retries_counter:
            req.add_header('X-Request-Attempt', str(try_count))
            handle     = None
            need_retry = False
            http_code  = 200
            is_error   = False
            result     = None
            resp_headers = {}
            start_time = time.time()

            try:
                handle = urllib2.urlopen(req, timeout=timeout)
            except urllib2.HTTPError, e:
                get_error_log().error(
                    'failed to open "%s", code: %s' % (theurl, str(e.code))
                )
                is_error  = True
                http_code = e.code
                need_retry = True
            except urllib2.URLError, e:
                get_error_log().error(
                    'failed to open "%s", reason: %s' % (theurl, str(e.reason))
                )
                is_error   = True
                http_code  = 500
                need_retry = True
            except Exception, e:
                get_error_log().error(
                    'failed to open "%s", exception: "%s"' % (theurl, str(e))
                )
                is_error   = True
                http_code  = 500
                need_retry = True
            else:
                try:
                    http_code = handle.getcode()
                    resp_headers = dict(handle.info())
                    result = handle.read()
                except Exception, e:
                    get_error_log().error(
                        'failed to read "%s", exception: "%s"' % (theurl, e.message)
                    )
                    is_error   = True
                    http_code  = 500
                    need_retry = True
            finally:
                end_time = time.time()
                if handle is not None:
                    handle.close()

            log_string = format_log_string(
                method,
                theurl,
                encoded_data,
                cookie_data,
                http_code,
                result,
                end_time - start_time,
                log_data=log_data,
                logged_data=logged_data,
                headers=req.headers,
            )

            # https://jira.yandex-team.ru/browse/CHEMODAN-15502
            # no more request logging in service log
            # log.info(log_string)
            try:
                requests_log.info(log_string.decode('utf-8'))
            except Exception:
                requests_log.info(log_string)

            if is_error and need_retry and retry:
                continue
            else:
                break

    if is_error:
        if api_err:
            err = api_err()
            try:
                err.data = {'text': e.read(), 'code': e.code, 'headers': dict(e.headers)}
            except Exception:
                err.data = {'text': '', 'code': '', 'headers': {}}
            raise (err,) + sys.exc_info()[1:]
        elif rais:
            raise
        elif return_status:
            return http_code, None, resp_headers
        else:
            return None
    else:
        if return_status:
            return http_code, result, resp_headers
        else:
            return result


def open_and_return_code(url, **kwargs):
    '''
    Метод вызова с возвратом кода ответа
    '''
    kwargs['rais'] = True

    try:
        open_url(url, **kwargs)
    except urllib2.HTTPError, e:
        return e.code
    except Exception, e:
        return 500
    else:
        return 200


def format_log_string(method, url, data, cookie, code, answer, time, log_data=True, logged_data=None, headers=None):
    '''
    Также используется в mpfs/engine/xmlrpc/client.py
    '''
    if not method:
        method = POST if data else GET

    result = '%s "%s' % (method, url)
    result = result.encode('ascii')  # URL адрес содержит только ascii символы
    bytes_read = 0
    bytes_sent = 0

    if data:
        bytes_sent += len(str(data))
        if log_data:
            sep = '&' if '?' in url else '?'
            result = '%s%s%s' % (result, sep, str(data))

    if logged_data:
        sep = '&' if '?' in url else '?'
        result = result + sep + '%s' % logged_data

    if cookie:
        bytes_sent += len(str(cookie))

    if answer:
        bytes_read += len(answer)

    if headers:
        result += ' headers:%s' % headers_to_log(headers, NOT_LOGGED_HEADERS)

    result += '" %s %s %s %.3f' % (code, str(bytes_sent), str(bytes_read), time)
    return result
