# -*- coding: utf-8 -*-

from mpfs.dao.base import BaseDAO, BaseDAOItem
from mpfs.dao.fields import ByteArrayField, MSKDateTimeField, ObjectIdField, UidField
from mpfs.metastorage.postgres.schema import async_tasks_data


class AsyncTasksDataDAOItem(BaseDAOItem):
    mongo_collection_name = 'async_tasks_data'
    postgres_table_obj = async_tasks_data
    is_sharded = True

    id = ObjectIdField(mongo_path='_id', pg_path=async_tasks_data.c.id)
    uid = UidField(mongo_path='uid', pg_path=async_tasks_data.c.uid)
    date_created = MSKDateTimeField(mongo_path='ctime', pg_path=async_tasks_data.c.date_created, default_value=None)
    data = ByteArrayField(mongo_path='data', pg_path=async_tasks_data.c.data, default_value=None)


class AsyncTasksDataDAO(BaseDAO):
    dao_item_cls = AsyncTasksDataDAOItem
