# -*- coding: utf-8 -*-
import datetime
import bson

from mpfs.core.models import Model, ModelField, ObjectIdField


class AsyncTasksData(Model):
    primary_key_field = 'id'
    id = ObjectIdField(source='_id')
    uid = ModelField(required=True)
    data = ModelField(required=True)
    ctime = ModelField(required=True)

    def __init__(self, **kwargs):
        super(AsyncTasksData, self).__init__(**kwargs)
        if not isinstance(kwargs.get('ctime'), datetime.datetime):
            self.ctime = datetime.datetime.now()

    def save(self, *args, **kwargs):
        if not self.ctime:
            self.ctime = datetime.datetime.now()
        if not self.id:
            self.id = bson.ObjectId()
            kwargs['force_insert'] = True
        super(AsyncTasksData, self).save(*args, **kwargs)
