# -*- coding: utf-8 -*-
"""
Временный модуль пока живут старые очереди для определения, какому job хендлеру соответствует какой celery таск

Заводя таск тут, не забудь завести в https://queller.disk.yandex-team.ru/z/celery-tasks
Подробности https://wiki.yandex-team.ru/disk/mpfs/meps/mep-062/
"""

from mpfs.common.static.tags.billing import (BILLING_ORDER_CALLBACK, BILLING_SUBSCRIPTION_CALLBACK,
                                             BILLING_SERVICE_STANDART_BILLING, BILLING_SERVICE_SUBSCRIPTION_DELAYED,
                                             BILLING_SERVICE_SUBSCRIPTION_CANCELLED,
                                             BILLING_INAPP_SERVICE_SYNCRONIZE, BILLING_INAPP_RESYNC_SUBS,
                                             MEDIABILLING_OK_CALLBACK, MEDIABILLING_CANCEL_CALLBACK)

from mpfs.core.job_handlers.operation import handle_operation, handle_service_operation, \
    handle_user_permanent_delete_operation, handle_user_preliminary_delete_operation, handle_filesystem_copy_operation, \
    handle_support_operation
from mpfs.core.job_handlers.operation_failing import handle_failing_operation
from mpfs.core.filesystem.cleaner import storage_duplicates
from mpfs.core.job_handlers import (
    indexer,
    routine,
    user,
    push,
    billing,
    aviary,
    notifier,
    yateam,
    trash_clean,
    fotki,
    global_gallery,
    discount,
    docs,
)
from mpfs.core.albums.job_handlers import handle_update_social_cover, handle_file_changed_operation, \
    handle_start_album_creation
from mpfs.core.lenta import job_handlers as lenta
from mpfs.core.organizations import job_handlers as organizations
from mpfs.core.last_files import job_handlers as last_files_jobs
from mpfs.core.public_links.tasks import handle_clean_expired_links
from mpfs.core.versioning import job_handlers as versioning_jobs
from mpfs.core.filesystem.cleaner.hidden import HiddenDataCleanerWorker
from mpfs.core.versioning.logic.cleaner import VersionsCleanerWorker
from mpfs.core.inactive_users_flow.logic import handle_process_inactive_users_flow_item

QUEUE2_JOB_TYPES_MAP = {
    'operation': handle_operation,  # mpfs.core.job_handlers.operation.handle_operation
    'user_preliminary_delete_operation': handle_user_preliminary_delete_operation,  # mpfs.core.job_handlers.operation.handle_user_preliminary_delete_operation
    'user_permanent_delete_operation': handle_user_permanent_delete_operation,  # mpfs.core.job_handlers.operation.handle_user_permanent_delete_operation
    'filesystem_copy_operation': handle_filesystem_copy_operation,  # mpfs.core.job_handlers.operation.handle_filesystem_copy_operation
    'operation_failing': handle_failing_operation,  # mpfs.core.job_handlers.operation_failing.handle_failing_operation
    'operation_service': handle_service_operation,  # mpfs.core.job_handlers.operation_service.handle_service_operation
    'operation_support': handle_support_operation,  # mpfs.core.job_handlers.operation_service.handle_support_operation

    'reindex': indexer.handle_reindex,  # mpfs.core.job_handlers.indexer.handle_reindex
    'search_reindex': indexer.handle_reindex_search,  # mpfs.core.job_handlers.indexer.handle_reindex_search
    'search': indexer.handle_notify_search_indexer,  # mpfs.core.job_handlers.indexer.handle_notify_search_indexer
    'search_photoslice': indexer.handle_notify_search_photoslice_indexer,  # mpfs.core.job_handlers.indexer.handle_notify_search_photoslice_indexer
    'notify_smart_cache_photo_slice_changed': indexer.handle_notify_smartcache_photoslice_changed,  # mpfs.core.job_handlers.indexer.handle_notify_smartcache_photoslice_changed
    'search_group': indexer.handle_notify_search_indexer_group,  # mpfs.core.job_handlers.indexer.handle_notify_search_indexer_group
    'search_photoslice_group': indexer.handle_search_photoslice_indexer_group,  # mpfs.core.job_handlers.indexer.handle_search_photoslice_indexer_group
    'search_missing_photoslice': indexer.handle_search_missing_photoslice,  # mpfs.core.job_handlers.indexer.handle_search_missing_photoslice
    'group_user_kicked_notify_search_index': indexer.handle_group_user_kicked_notify_search_index,  # mpfs.core.job_handlers.indexer.handle_group_user_kicked_notify_search_index
    'push_invite_activated': indexer.handle_push_invite_activated,   # mpfs.core.job_handlers.indexer.handle_push_invite_activated

    'post_remove': routine.handle_post_remove,  # mpfs.core.job_handlers.routine.handle_post_remove
    'update_hardlink': routine.handle_update_hardlink,  # mpfs.core.job_handlers.routine.handle_update_hardlink
    'symlinks_remove': routine.handle_symlink_remove,  # mpfs.core.job_handlers.routine.handle_symlink_remove
    'symlinks_update': routine.handle_symlink_update,  # mpfs.core.job_handlers.routine.handle_symlink_update
    'call_url': routine.handle_call_url,  # mpfs.core.job_handlers.routine.handle_call_url
    'send_email': routine.handle_send_email,  # mpfs.core.job_handlers.routine.handle_send_email
    'send_email_space': routine.handle_send_email_space,  # mpfs.core.job_handlers.routine.handle_send_email_space
    'email_sender_send': routine.handle_email_sender_send,  # mpfs.core.job_handlers.routine.handle_email_sender_send
    'group_setsize': routine.handle_set_group_size,  # mpfs.core.job_handlers.routine.handle_set_group_size
    'make_folder_content_private': routine.handle_make_folder_content_private,  # mpfs.core.job_handlers.routine.handle_make_folder_content_private
    'make_shared_root_public': routine.handle_make_shared_root_public,  # mpfs.core.job_handlers.routine.handle_make_shared_root_public
    'sync_public_fields_from_link_data': routine.handle_sync_public_fields_from_link_data,  # mpfs.core.job_handlers.routine.handle_sync_public_fields_from_link_data
    'sync_office_fields_from_link_data': routine.handle_sync_office_fields_from_link_data,  # mpfs.core.job_handlers.routine.handle_sync_office_fields_from_link_data
    'make_shared_root_private': routine.handle_make_shared_root_private,  # mpfs.core.job_handlers.routine.handle_make_shared_root_private
    'trash_restore_all': routine.handle_trash_restore_all,  # mpfs.core.job_handlers.routine.handle_trash_restore_all
    'trash_clean': trash_clean.handle_trash_clean,  # mpfs.core.job_handlers.trash_clean.handle_trash_clean
    'restore_deleted': routine.handle_restore_deleted,  # mpfs.core.job_handlers.routine.handle_restore_deleted
    'block_uids_by_hid': routine.handle_block_uids_by_hid,  # mpfs.core.job_handlers.routine.handle_block_uids_by_hid
    'always_raise': routine.handle_always_raise,  # mpfs.core.job_handlers.routine.handle_always_raise
    HiddenDataCleanerWorker.get_queue_task_name(): HiddenDataCleanerWorker(), # mpfs.core.filesystem.cleaner.hidden.HiddenDataCleanerWorker

    'post_process_user_var': user.handle_post_modify_user_settings,  # mpfs.core.job_handlers.user.handle_post_modify_user_settings
    'post_process_user_init': user.handle_post_process_user_init,  # mpfs.core.job_handlers.user.handle_post_process_user_init
    'process_device_install': user.handle_process_device_install,  # mpfs.core.job_handlers.user.handle_process_device_install
    'handle_passport_user_deleted_event': user.handle_passport_user_deleted_event,  # mpfs.core.job_handlers.user.handle_passport_user_deleted_event

    'xiva': push.handle_push_notification,  # mpfs.core.job_handlers.push.handle_push_notification
    'xiva_subscribe': push.handle_push_notify_subscribe,  # mpfs.core.job_handlers.push.handle_push_notify_subscribe
    'xiva_browser': push.handle_push_xiva_browser,  # mpfs.core.job_handlers.push.handle_push_xiva_browser

    BILLING_ORDER_CALLBACK: billing.handle_billing_order_callback,  # mpfs.core.job_handlers.billing.handle_billing_order_callback
    BILLING_SUBSCRIPTION_CALLBACK: billing.handle_billing_subscription_callback,  # mpfs.core.job_handlers.billing.handle_billing_subscription_callback
    BILLING_SERVICE_STANDART_BILLING: billing.handle_billing_service_standart_billing,  # mpfs.core.job_handlers.billing.handle_billing_service_standart_billing
    BILLING_SERVICE_SUBSCRIPTION_DELAYED: billing.handle_billing_service_subscription_delayed,  # mpfs.core.job_handlers.billing.handle_billing_service_subscription_delayed
    BILLING_SERVICE_SUBSCRIPTION_CANCELLED: billing.handle_billing_service_subscription_cancelled,  # mpfs.core.job_handlers.billing.handle_billing_service_subscription_cancelled
    BILLING_INAPP_SERVICE_SYNCRONIZE: billing.handle_billing_inapp_service_syncronize,  # mpfs.core.job_handlers.billing.handle_billing_inapp_service_syncronize
    BILLING_INAPP_RESYNC_SUBS: billing.handle_billing_resync_inapp_subs,  # mpfs.core.job_handlers.billing.handle_billing_resync_inapp_sub
    MEDIABILLING_OK_CALLBACK: billing.handle_mediabilling_subscription_ok,
    MEDIABILLING_CANCEL_CALLBACK: billing.handle_mediabilling_subscription_cancelled,

    'aviary_check_render_status': aviary.handle_check_aviary_render_status,  # mpfs.core.job_handlers.aviary.handle_check_aviary_render_status

    'albums_update_social_cover': handle_update_social_cover,  # mpfs.core.albums.job_handlers.handle_update_social_cover

    'file_changed_operation': handle_file_changed_operation,  # mpfs.core.albums.job_handlers.handle_file_changed_operation
    'create_geo_albums_operation': handle_start_album_creation,  # mpfs.core.albums.job_handlers.handle_start_album_creation

    'lenta_delete_empty_block': lenta.lenta_delete_empty_block,  # mpfs.core.lenta.job_handlers.lenta_delete_empty_block

    'notifier_add_notification': notifier.handle_notifier_add_notification,  # mpfs.core.job_handlers.notifier.handle_notifier_add_notification

    'move_yateam_folder_to_chief': yateam.handle_move_yateam_folder_to_chief,   # mpfs.core.job_handlers.yateam.handle_move_yateam_folder_to_chief
    'update_user_yateam_status': yateam.handle_update_user_yateam_status,   # mpfs.core.job_handlers.yateam.handle_update_user_yateam_status
    'restore_yateam_folder': yateam.handle_restore_yateam_folder,   # mpfs.core.job_handlers.yateam.handle_restore_yateam_folder

    'calculate_organization_used_space': organizations.handle_calculate_organization_used_space,  # mpfs.core.organizations.job_handlers.handle_calculate_organization_used_space
    'update_organization': organizations.handle_update_organization,  # mpfs.core.organizations.job_handlers.handle_update_organization
    'update_b2b_key': organizations.handle_update_b2b_key,  # mpfs.core.organizations.job_handlers.handle_update_b2b_key
    'update_last_files_cache': last_files_jobs.handle_update_last_files_cache,  # mpfs.core.last_files.job_handlers.handle_update_last_files_cache

    'remove_versions': versioning_jobs.handle_remove_versions,
    'truncate_versions': versioning_jobs.handle_truncate_versions,
    VersionsCleanerWorker.get_queue_task_name(): VersionsCleanerWorker(),
    'remove_from_fotki_proxy': fotki.handle_remove_from_fotki_proxy,  # mpfs.core.job_handlers.fotki.handle_remove_from_fotki_proxy
    'regenerate_preview_for_files': routine.handle_regenerate_preview_for_files,  # mpfs.core.job_handlers.routine.handle_regenerate_preview_for_files

    'add_source_ids': global_gallery.handle_add_source_ids,  # mpfs.core.job_handlers.global_gallery.handle_add_source_ids
    'add_deletion_log_record_if_needed_by_file_data': global_gallery.handle_add_deletion_log_record_if_needed_by_file_data,  # mpfs.core.job_handlers.global_gallery.handle_add_deletion_log_record_if_needed_by_file_data
    'set_live_photo_flag_to_source_ids_and_add_one': global_gallery.handle_set_live_photo_flag_to_source_ids_and_add_one,  # mpfs.core.job_handlers.global_gallery.handle_set_live_photo_flag_to_source_ids_and_add_one

    'provide_discount_to_come_back_user': discount.handle_provide_discount_to_come_back_user,  # mpfs.core.job_handlers.discount.handle_provide_discount_to_come_back_user

    'no_discount_follow_up_email': routine.handle_no_discount_follow_up_email,  # mpfs.core.job_handlers.routine.handle_no_discount_follow_up_email
    'with_discount_follow_up_email': routine.handle_with_discount_follow_up_email,  # mpfs.core.job_handlers.routine.handle_with_discount_follow_up_email

    'storage_duplicate_clean': storage_duplicates.handle_storage_duplicate_clean,  # mpfs.core.last_files.job_handlers.handle_update_last_files_cache
    'process_inactive_users_flow_item': handle_process_inactive_users_flow_item,  # mpfs.core.inactive_users_flow.logic.handle_process_inactive_users_flow_item
    'delete_objects_in_docs': docs.handle_delete_objects_in_docs, # mpfs.core.job_handlers.docs.handle_delete_objects_in_docs
    'clean_expired_links': handle_clean_expired_links, # mpfs.core.public_links.tasks.clean_expired_links
}
