# -*- coding: utf-8 -*-

from __future__ import absolute_import

from celery.worker.job import task_ready, string
from celery.exceptions import WorkerLostError, Terminated, Retry


def get_on_failure_patch(log):
    def on_failure(self, exc_info):
        """Манкипатч с бэкпортом вот этого фикса для 4.0 на 3.1: https://github.com/celery/celery/issues/1628"""
        task_ready(self)
        send_failed_event = True

        if not exc_info.internal:
            exc = exc_info.exception

            if isinstance(exc, Retry):
                return self.on_retry(exc_info)

            # These are special cases where the process would not have had
            # time to write the result.
            if self.store_errors:
                if isinstance(exc, WorkerLostError):
                    self.task.backend.mark_as_failure(
                        self.id, exc, request=self,
                    )
                elif isinstance(exc, Terminated):
                    self._announce_revoked(
                        'terminated', True, string(exc), False)
                    send_failed_event = False  # already sent revoked event
            # (acks_late) acknowledge after result stored.
            if self.task.acks_late:
                reject = isinstance(exc, WorkerLostError) and 'signal' in exc.message
                # знаю, что тут нечем гордиться, и я тут сделал проверку на то, был срублен воркер через sys.exit или
                # через сигнал (SIGKILL или SIGTERM), через наличие в message слова signal, но я потратил день
                # на то, чтобы выяснить, как это сделать через celery/billiard/kombu и мне это не удалось. Сделать то
                # было можно, но выглядело бы это просто УЖАСНО, так что имеем то, что имеем. По делу:
                # сигнал означает, что воркер был срублен по сигналу (а если, к примеру, там будет exitcode, то это
                # значит, что воркер срубил сам себя через sys.exit (в проверке лимитов в task_postrun)
                requeue = self.delivery_info.get('redelivered', None) is False

                if reject:
                    self.reject(requeue=requeue)
                    log.info('Task %s rejected with requeue=%s' % (self.id, requeue))
                else:
                    self.acknowledge()
        self._log_error(exc_info, send_failed_event=send_failed_event)

    return on_failure
