# -*- coding: utf-8 -*-
"""

Окружение глобальных переменных в рамках запроса.
Если работаем в асинхронном режиме, то используем глобальное окружение gevent. Иначе используем обычное глобальное
окружение. Не используем окружение threading, чтобы не сломать мультитредовые запросы. За состоянием устанавливаемых
глобальных переменных на запрос необходимо следить вручную и восстанавливать значения в начале обработке запроса (как
это делается для tld)

"""

_greenlet_local_data = None
_local_data = {}
_is_greenlet_local_data_available = False

try:
    from gevent.local import local
    _is_greenlet_local_data_available = True
except ImportError:
    _is_greenlet_local_data_available = False


def enable_greenlet_local_data():
    if not _is_greenlet_local_data_available:
        raise RuntimeError('enable_greenlet_local_data is called but gevent is not installed.')
    global _greenlet_local_data
    _greenlet_local_data = local()


def get_request_global_variable(key):
    if _greenlet_local_data is not None:
        return getattr(_greenlet_local_data, key, None)
    else:
        return _local_data.get(key)


def set_request_global_variable(key, value):
    if _greenlet_local_data is not None:
        setattr(_greenlet_local_data, key, value)
    else:
        _local_data[key] = value
