# -*- coding: utf-8 -*-
"""

MPFS
ENGINE

XMLRPC-агент

"""
import socket
import xmlrpclib
import time

import mpfs.engine.process
from mpfs.engine.http.client import format_log_string

default_log  = mpfs.engine.process.get_default_log()
error_log    = mpfs.engine.process.get_error_log()
requests_log = mpfs.engine.process.get_requests_log()

def call(server, method, log=None, timeout=5, api_err=None, *args):
    handler = xmlrpclib.ServerProxy(server)
    start   = time.time()
    code    = 200
    result  = None
    
    try:
        socket.setdefaulttimeout(timeout)
        result = getattr(handler, method)(*args)
    except Exception, e:
        error_log.error('failed to open %s/%s: %s' % (server, method, str(e)))
        code = 500
        result = str(e)
    finally:
        socket.setdefaulttimeout(None)
        end = time.time()

    url = '%s/%s' % (server, method)

    log_string = format_log_string(
        method=None,
        url=url,
        data=args,
        cookie=None,
        code=code,
        answer=result,
        time=end - start,
    )

    requests_log.info(log_string)
    log.info(log_string)
    return result