# -*- coding: utf-8 -*-
'''
API браузера

поля одной записи
entity = ('id_string', 'share', 'type', 'parent_id_string', 'type',
           'parent_id_string', 'version', 'mtime', 'ctime', 'name',
           'server_defined_unique_tag', 'deleted', 'originator_cache_guid',
           'originator_client_item_id', 'specifics', 'folder', 
           'client_defined_unique_tag',)
'''


import re


import mpfs.common.util

from mpfs.engine.process import get_default_log, get_error_log
from mpfs.frontend.api.disk import Default
from mpfs.core import browser
from mpfs.frontend.request import BrowserRequest

log = get_default_log()
error_log = get_error_log()


class Browser(Default):
    '''
    API для браузера
    '''
    client = 'browser'
    core = browser
    req_class = BrowserRequest

    def _process(self, *args, **kwargs):
        return super(Browser, self)._process(*args, **kwargs)

    def get_updates(self):
        '''
        share - uid пользователя
        type - тип возвращаемых объектов
        max_entities - количество возвращаемых объектов
        old_version - версия, старше которой нужно вернуть объекты
        '''
        uid = str(self.params.pop('u'))
        try:
            limit = int(self.params.pop('max_entities'))
        except KeyError:
            limit = None
        args = {
                'uid' : uid,
                'limit' : limit,
                'client_id' : str(self.params.pop('c', '')),
                'types' : map(lambda (t,v): (int(t), int(v)), self.params.iteritems()),
                }
        self.process_core_method('get_updates', args)

    def delete(self):
        """
        u - uid пользователя
        data - список значений вида {"id": <id>, "v": <version>}
        """
        keys = (
            ('uid', 'u', str),
            ('entities', 'data', str),
        )
        self.process_core_method('delete', keys=keys)

    def commit(self):
        '''
        new_entity: {k : v} проставление или обновление значения
        '''
        
        keys = (
                ('entities', 'data', mpfs.common.util.from_json),
                ('client_id', 'c', str, ''),
                )
        self.process_core_method('commit', keys=keys)

    def commit_initial(self):
        return self.commit()

    def drop(self):
        '''
        drop data for user
        '''
        keys = (
                ('uid', 'u', str),
                ('client_id', 'c', str, ''),
                )
        self.process_core_method('drop', keys=keys)

    def delete_subtree(self):
        keys = (
                ('uid', 'u', str),
                ('ids', 'data', mpfs.common.util.from_json),
                ('client_id', 'c', str, ''),
                )
        self.process_core_method('delete_subtree', keys=keys)

    def subscribe(self):
        args = {
                'uid' : str(self.params.pop('u')),
                'callback' : str(self.params.pop('callback')),
                'options' : {
                             'client_id' : str(self.params.pop('c', '')),
                             'types' : map(int, re.split(',', str(self.params.pop('t')))),
                             }
                }
        args['options'].update(self.params)
        self.process_core_method('subscribe', args)

    def unsubscribe(self):
        keys = (
                ('uid' , 'u', str),
                ('client_id', 'c' , str, ''),
                ('callback', 'callback', str),
                )
        self.process_core_method('unsubscribe', keys=keys)

    def set_state(self):
        keys = (
                ('uid', 'u', str),
                ('states', 'data', mpfs.common.util.from_json),
                )
        self.process_core_method('set_state', keys=keys)

    def get_state(self):
        keys = (
                ('uid', 'u', str),
                )
        self.process_core_method('get_state', keys=keys)

    def set_state_with_version(self):
        keys = (
                ('uid', 'u', str),
                ('states', 'data', mpfs.common.util.from_json),
        )
        version = str(self.params.pop('version'))
        version = None if version == 'null' else int(version)
        args = {'version': version}

        self.process_core_method('set_state_with_version', args=args, keys=keys)

    def get_state_with_version(self):
        keys = (
                ('uid', 'u', str),
        )
        self.process_core_method('get_state_with_version', keys=keys)

    def user_info(self):
        keys = (
                ('uid', 'u', str),
                )
        self.process_core_method('user_info', keys=keys)

    def notify(self):
        keys = (
            ('uid', 'u', str),
            ('client_id', 'c', str),
        )
        self.process_core_method('notify', keys=keys)
