# -*- coding: utf-8 -*-
"""

MPFS
API биллинга

"""
import mpfs.engine.process

from mpfs.config import settings
from mpfs.frontend.formatter.disk.billing import Billing as formatter
from mpfs.frontend.api import Default
from mpfs.core import billing
from mpfs.common.static.tags.billing import *
from mpfs.common.util import type_to_bool

log = mpfs.engine.process.get_access_log()
error_log = mpfs.engine.process.get_error_log()

VALID_BB_DOMAINS = settings.system['valid_billing_top_level_domains']


class Billing(Default):
    '''
    API биллинга
    Выдает результаты в json
    Описание формата:
    '''
    client = 'billing'
    core = billing
    formatter = formatter

    def compose_args(self, keys):
        self.params.pop('connection_id', '')
        return super(Billing, self).compose_args(keys)

    def process_core_method(self, *args, **kwargs):
        if not settings.billing['enabled']:
            self.req.set_result({})
            return

        super(Billing, self).process_core_method(*args, **kwargs)

    def product_list(self):
        keys = (
            ('uid', 'uid', str, None),
            ('line', 'line', str, PRIMARY_2013),
            ('market', 'market', str, None),
            ('group_uids', 'group_uids', str, None),
        )
        self.process_core_method('product_list', keys=keys)

    def verstka_products(self):
        keys = (
            ('uid', 'uid', str, None),
            ('locale', 'locale', str, 'ru'),
            ('ip', 'ip', str, None),
        )
        self.process_core_method('verstka_products', keys=keys)

    def inapp_product_card(self):
        keys = (
            ('uid', 'uid', str, None),
            ('store_id', 'store_id', str, None),
        )
        self.process_core_method('inapp_product_card', keys=keys)

    def inapp_products(self):
        keys = (
            ('uid', 'uid', str, None),
            ('locale', 'locale', str, 'ru'),
            ('store_id', 'store_id', str, None),
        )
        self.process_core_method('inapp_products', keys=keys)

    def client_set_attribute(self):
        keys = (
            ('uid', 'uid', str),
            ('attr', 'attr', str),
            ('value', 'value', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('client_set_attribute', keys=keys)

    def client_remove_attribute(self):
        keys = (
            ('uid', 'uid', str),
            ('attr', 'attr', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('client_remove_attribute', keys=keys)

    def client_list_attributes(self):
        keys = (
            ('uid', 'uid', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('client_list_attributes', keys=keys)


    def client_list_payment_methods(self):
        keys = (
            ('uid', 'uid', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('client_list_payment_methods', keys=keys)


    def client_bind_market(self):
        keys = (
            ('uid', 'uid', str),
            ('market', 'market', str, None),
            ('ip', 'ip', str),
        )
        self.process_core_method('client_bind_market', keys=keys)

    def order_place(self):
        keys = (
            ('uid', 'uid', str),
            ('pid', 'pid', str),
            ('line', 'line', str, PRIMARY_2013),
            ('payment_method', 'payment_method', str),
            ('auto', 'auto', type_to_bool, False),
            ('ip', 'ip', str),
            ('locale', 'locale', str, 'ru'),
            ('group_uids', 'group_uids', str, None),
            ('group_name', 'group_name', str, None),
        )
        self.process_core_method('order_place', keys=keys)

    def order_make_payment(self):
        keys = (
            ('uid', 'uid', str),
            ('number', 'number', str),
            ('ip', 'ip', str),
            ('return_path', 'return_path', str, ''),
            ('template_tag', 'template_tag', str, 'desktop/form'),
            ('locale', 'locale', str, 'ru'),
            ('pid', 'pid', str, None),
        )
        self.process_core_method('order_make_payment', keys=keys)

    def buy(self):
        args = {
            'uid': str(self.params.pop('uid')),
            'pid': str(self.params.pop('pid')),
            'payment_method': str(self.params.pop('payment_method')),
            'auto': type_to_bool(self.params.pop('auto', False)),
            'ip': str(self.params.pop('ip')),
            'locale': str(self.params.pop('locale', 'ru')),
            'return_path': str(self.params.pop('return_path', '')),
            'template_tag': str(self.params.pop('template_tag', 'desktop/form')),
            'from_': str(self.params.pop('from', '')),
        }
        for p in ('group_uids', 'group_name'):
            if p not in self.params:
                args[p] = None
                continue
            args[p] = str(self.params.pop(p))

        if self.req.tld in VALID_BB_DOMAINS:
            args['bb_tld'] = self.req.tld
        else:
            args['bb_tld'] = None

        self.process_core_method('buy', args)

    def process_receipt(self):
        args = {
            'uid': str(self.params.pop('uid')),
            'store_id': str(self.params.pop('store_id'))
        }
        self.process_core_method('process_receipt', args)

    def inapp_callback(self):
        self.process_core_method('inapp_callback', {})

    def order_list_current(self):
        keys = (
            ('uid', 'uid', str),
        )
        self.process_core_method('order_list_current', keys=keys)

    def order_list_history(self):
        keys = (
            ('uid', 'uid', str),
        )
        self.process_core_method('order_list_history', keys=keys)

    def order_process_callback(self):
        keys = (
            ('uid', 'uid', str, None),
            ('number', 'number', str),
            ('status', 'status', str),
            ('status_code', 'status_code', str, None),
            ('mode', 'mode', str, None),
            ('trust_refund_id', 'trust_refund_id', str, None),
        )
        self.process_core_method('order_process_callback', keys=keys)

    def process_mediabilling_callback(self):
        keys = (
            ('uid', 'uid', str, None),
        )
        self.process_core_method('process_mediabilling_callback', keys=keys)

    def order_recall(self):
        keys = (
            ('uid', 'uid', str, None),
            ('number', 'number', str),
            ('status', 'status', str),
            ('status_code', 'status_code', str, None),
        )
        self.process_core_method('order_recall', keys=keys)

    def subscription_process_callback(self):
        keys = (
            ('uid', 'uid', str, None),
            ('number', 'number', str),
            ('status', 'status', str),
            ('status_code', 'status_code', str, None),
            ('mode', 'mode', str, None),
            ('trust_refund_id', 'trust_refund_id', str, None),
        )
        self.process_core_method('subscription_process_callback', keys=keys)

    def _prepare_args_for_service_create(self):
        self.params.pop('connection_id', None)
        return {
            'uid': str(self.params.pop('uid')),
            'pid': str(self.params.pop('pid')),
            'market': self.params.pop('market', None),
            'line': self.params.pop('line', None),
            'auto_init_user': bool(int(self.params.pop('auto_init_user', 0))),
            'send_email': bool(int(self.params.pop('send_email', 1))),
            'ip': str(self.params.pop('ip')),
            'attributes': self.params,
        }

    def service_create(self):
        args = self._prepare_args_for_service_create()
        self.process_core_method('service_create', args)

    def service_create_for_ps_billing(self):
        args = self._prepare_args_for_service_create()
        self.process_core_method('service_create_for_ps_billing', args)

    def service_delete(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str, None),
            ('pid', 'pid', str, None),
            ('send_email', 'send_email', int, 1),
            ('ip', 'ip', str),
        )
        self.process_core_method('service_delete', keys=keys)

    def service_list(self):
        keys = (
            ('uid', 'uid', str),
            ('ip', 'ip', str),
            ('from_db', 'from_db', int, 0),
        )
        self.process_core_method('service_list', keys=keys)

    def service_list_history(self):
        keys = (
            ('uid', 'uid', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('service_list_history', keys=keys)

    def service_process_billing(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str),
        )
        self.process_core_method('service_process_billing', keys=keys)

    def service_prolongate(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str),
            ('payment_method', 'payment_method', str),
            ('ip', 'ip', str),
            ('locale', 'locale', str, 'ru'),
        )
        self.process_core_method('service_prolongate', keys=keys)

    def service_unsubscribe(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('service_unsubscribe', keys=keys)

    def service_set_attribute(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str),
            ('key', 'key', str),
            ('value', 'value', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('service_set_attribute', keys=keys)

    def service_remove_attribute(self):
        keys = (
            ('uid', 'uid', str),
            ('sid', 'sid', str),
            ('key', 'key', str),
            ('ip', 'ip', str),
        )
        self.process_core_method('service_remove_attribute', keys=keys)

    def order_list_history_revise(self):
        keys = (
            ('ctime_gt', 'ctime_gt', int, None),
            ('ctime_lt', 'ctime_lt', int, None),
        )
        self.process_core_method('order_list_history_revise', keys=keys)

    def order_list_filtered(self):
        keys = (
            ('uid', 'uid', str),
            ('filters', 'filters', str, ''),
            ('iteration_key', 'iteration_key', str, None),
        )
        self.process_core_method('order_list_filtered', keys=keys)

    def order_set_payment_processing_state(self):
        keys = (
            ('uid', 'uid', str),
            ('number', 'number', str),
        )
        self.process_core_method('order_set_payment_processing_state', keys=keys)

    def refund_order(self):
        keys = (
            ('uid', 'uid', str),
            ('number', 'number', str),
            ('reason', 'reason', str),
        )
        self.process_core_method('refund_order', keys=keys)

    def refund_order_status(self):
        keys = (
            ('uid', 'uid', str),
            ('number', 'number', str),
        )
        self.process_core_method('refund_order_status', keys=keys)
