# -*- coding: utf-8 -*-

from mpfs.frontend.api.disk import DiskApi
from mpfs.frontend.formatter.disk.json import JSON
from mpfs.frontend.request import JSONRequest
from mpfs.common.util import from_json


class JSON(DiskApi):
    '''
    API для json клиента
    Выдает результаты в json
    '''
    client = 'json'
    formatter = JSON
    req_class = JSONRequest

    #===========================================================================
    # Теги CHEMODAN-14569
    def tags_get_elements_for_tag(self):
        '''
            Not in use
        '''
        args = self.base_args()
        args['data'] = self.params
        self.process_core_method('elements_for_tag', args)

    def tags_get_tags_for_element(self):
        '''
            Not in use
        '''
        args = self.base_args()
        self.process_core_method('tags_for_element', args)

    def tags_get_tags_in_folder_list(self):
        '''
            Not in use
        '''
        args = self.base_args()
        self.process_core_method('tags_in_folder_list', args)

    def tags_get_tags_in_folder_tree(self):
        '''
            Not in use
        '''
        args = self.base_args()
        self.process_core_method('tags_in_folder_tree', args)

    def tags_get_elements_in_folder_list(self):
        '''
            Not in use
        '''
        args = self.base_args()
        args['data'] = self.params.items()
        self.process_core_method('elements_in_folder_list', args)

    def tags_get_elements_in_folder_tree(self):
        '''
            Not in use
        '''
        args = self.base_args()
        args['data'] = self.params.items()
        self.process_core_method('elements_in_folder_tree', args)

    def tags_set(self):
        '''
            Not in use
        '''
        args = self.base_args()
        args['scope'] = self.params['scope']
        args['data'] = self.params['data']
        self.process_core_method('tags_set', args)

    def tags_photo_timeline(self):
        # GET
        args = self.base_args()
        # POST
        if 'system_tags' in self.params:
            args['system_tags'] = from_json(self.params['system_tags'])
        else:
            args['system_tags'] = {}
        if 'user_tags' in self.params:
            args['user_tags'] = from_json(self.params['user_tags'])
        else:
            args['user_tags'] = []
        self.process_core_method('tags_photo_timeline', args)

    def tags_photo_list(self):
        # GET
        args = self.base_args()
        # POST
        args['filters'] = from_json(self.params['filters'])
        if 'system_tags' in self.params:
            args['system_tags'] = from_json(self.params['system_tags'])
        else:
            args['system_tags'] = {}
        if 'user_tags' in self.params:
            args['user_tags'] = from_json(self.params['user_tags'])
        else:
            args['user_tags'] = []
        self.process_core_method('tags_photo_list', args)

    def tags_set_all_photo(self):
        args = self.base_args()
        self.process_core_method('tags_set_photo_all', args)
    #===========================================================================