# -*- coding: utf-8 -*-

from mpfs.common.errors import MPFSNotImplemented
from mpfs.frontend.api.disk import DiskApi
from mpfs.frontend.formatter.disk.mail import Mail
from mpfs.frontend.formatter.disk.json import JSON
from mpfs.frontend.request import MailRequest


class Mail(DiskApi):
    '''
    API для почтового веб-интерфейса
    Выдает результаты в xml
    Описание формата: http://wiki.yandex-team.ru/MixailBelov/PFS/API/Mail
    '''
    client = 'mail'
    formatter = Mail
    req_class = MailRequest

    # никто больше не пользуется, убираем
    def mkdir(self):
        raise MPFSNotImplemented()
