# -*- coding: utf-8 -*-
"""

MPFS
API Фотосреза

"""
import mpfs.engine.process

from mpfs.frontend.api import Default
from mpfs.frontend.formatter.disk.photoslice import Photoslice
from mpfs.core.photoslice import interface

log = mpfs.engine.process.get_access_log()
error_log = mpfs.engine.process.get_error_log()


class Photoslice(Default):
    """
    Выдает результаты в json
    """
    client = 'photoslice'
    core = interface
    formatter = Photoslice

    def periods(self):
        self.periods_counts()

    def periods_counts(self):
        keys = (
            ('uid', 'uid', str, None),
        )
        self.process_core_method('periods_counts', keys=keys)

    def periods_ids(self):
        keys = (
            ('uid', 'uid', str, None),
        )
        self.process_core_method('periods_ids', keys=keys)

    def resources(self):
        keys = (
            ('uid', 'uid', str, None),
            ('amount', 'amount', int, 40),
            ('offset', 'offset', int, 0),
            ('version', 'version', int, 0),
        )
        self.process_core_method('resources', keys=keys)