# -*- coding: utf-8 -*-
"""

MPFS
API инвайтилки

"""
import sys, traceback
from time import time as now

import mpfs.engine.process
import mpfs.common.util.logger as logger

from mpfs.frontend import request
from mpfs.common import errors
from mpfs.frontend.formatter import invite_formatter
from mpfs.frontend.api import API
from mpfs import invite 

log = mpfs.engine.process.get_access_log()
error_log = mpfs.engine.process.get_error_log()


class Invite(API):
    '''
    API инвайтилки
    Выдает результаты в json
    Описание формата: http://wiki.yandex-team.ru/pochta/ya.disk/MPFS/API/Invite
    '''
    client = 'invite'
    formatter = invite_formatter.Invite
    
    def enqueue(self):
        '''
        Постановка email в очередь
        '''
        args = {
            'address' : self.params.pop('address'),
            'project' : self.params.pop('project', 'mpfs'),
        }
        args['info'] = self.params
        self.req.set_args(args)
        self.req.set_result(invite.enqueue(self.req))
        
    def activate(self):
        '''
        Активирование кода
        '''
        args = {
            'code' : str(self.params.pop('code')),
            'uid'  : self.params.pop('uid'),
            'project' : self.params.pop('project', 'mpfs'),
        }
        args['info'] = self.params
        self.req.set_args(args)
        self.req.set_result(invite.activate(self.req))
        
    def info(self):
        '''
        Выдача информации по пользователю, выдавшему инвайт
        '''
        args = {
            'code' : str(self.params.pop('code')),
            'project' : self.params.pop('project', 'mpfs'),
        }
        self.req.set_args(args)
        self.req.set_result(invite.info(self.req))
