# -*- coding: utf-8 -*-
'''
MPFS
Дефолтный форматтер
'''
import re

import mpfs.engine.process
from mpfs.common.static import messages
from mpfs.common.static import codes
from mpfs.common.static.tags import *
from mpfs.common import errors
from mpfs.common.util import to_json
from mpfs.frontend.formatter.util import *


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

REMOVE_RE = re.compile(u'[\x00-\x08\x0B-\x0C\x0E-\x1F\x7F]')


class Default(object):

    content_type = 'text/javascript; charset=utf-8'
        
    def setup(self, **kw):
        self.request = kw['request']
        self.request.http_resp.headers['Content-Type'] = self.content_type

    def process(self, f, **kw):
        self.data = self.request.data

        if self.request.is_default_formatter_required:
            handler = self.default_handler
        else:
            try:
                handler = getattr(self, f)
            except AttributeError:
                handler = self.default_handler

        return handler(**kw)

    def default_handler(self, *args, **kwargs):
        return self.to_json(self.request.data[RESULT], compactly=False)
    
    def to_json(self, data, compactly=True):
        return to_json(data, compactly=compactly)
       
    def error(self, err):
        try:
            if isinstance(err, Exception):
                result = {}
                if isinstance(err, errors.MPFSRootException):
                    result.update(err.repr())
                else:
                    result['message']  = str(err)
                    result['code'] = codes.MPFS_ERROR
            else:
                result = self.request.data
        except Exception:
            result = self.request.data
        self.request.http_resp.status = result.get('response', messages.default_response)
        return self.to_json(result)

    def _set_text(self, node, data, tag=None):
        if not tag:
            tag = node.tag
        if data is None:
            data = ''
        if not isinstance(data, (str, unicode)):
            data = str(data)
        if isinstance(data, str):
            data = data.decode('utf-8')
        data = unicode(data)
        try:
            node.text = data
        except ValueError:
            node.text = REMOVE_RE.sub('', data)

    def xml_error(self, err):
        response = etree.Element(RESPONSE, status="0")
        err_element = etree.SubElement(response, ERROR)
        error_title = etree.SubElement(err_element, TITLE)
        error_code = etree.SubElement(err_element, CODE)
        http_error_code = messages.default_response
        if isinstance(err, Exception):
            if isinstance(err, errors.MPFSRootException):
                self._set_text(error_title, err.message)
                self._set_text(error_code, getattr(err, 'code', ''))
                http_error_code = getattr(err, 'response', messages.default_response)
            else:
                try:
                    title = messages.titles.get(int(err))
                    http_error_code = messages.responses.get(int(err))
                except Exception:
                    title = type(err)
                self._set_text(error_title, title)
                self._set_text(error_code, err)
        self.request.http_resp.headers['Content-Type'] = 'text/xml'
        return etree.tostring(response, pretty_print=True), http_error_code

    def ping(self):
        return self.request.data[RESULT]

    def ping_slb(self):
        return self.ping()

    def ping_localbase(self):
        return self.ping()
