# -*- coding: utf-8 -*-

import mpfs.engine.process
from mpfs.common.static.tags.billing import *
from mpfs.frontend.formatter.disk import MPFSFormatter

class Billing(MPFSFormatter):

    content_type = 'application/json; charset=utf-8'

    def default_success(self):
        return self.to_json({})

    def product_list(self, **kw):
        return self.to_json(self.request.data['result'])

    def client_set_attribute(self, **kw):
        return self.default_success()

    def client_remove_attribute(self, **kw):
        return self.default_success()

    def client_bind_market(self, **kw):
        return self.default_success()

    def client_list_attributes(self, **kw):
        return self.to_json(self.request.data['result'])

    def client_list_payment_methods(self, **kw):
        return self.to_json(self.request.data['result'])

    def order_place(self, **kw):
        return self.to_json({'number': self.request.data['result']})

    def order_make_payment(self, **kw):
        return self.to_json(self.request.data['result'])

    def service_create(self, **kw):
        return self.to_json({'sid': self.request.data['result']['sid'],
                             'btime': self.request.data['result']['btime']})

    def service_create_for_ps_billing(self, **kw):
        return self.to_json({'sid': self.request.data['result']['sid'],
                             'btime': self.request.data['result']['btime']})

    def service_delete(self, **kw):
        return self.default_success()

    def service_process_billing(self, **kw):
        return self.default_success()

    def service_list(self, **kw):
        result = []
        for item in self.request.data['result']:
            result.append(format_service_data(item))

        return self.to_json(result)

    def service_list_history(self, **kw):
        result = []
        for item in self.request.data['result']:
            formatted_item = {
                'sid': item[SID],
                'name': item[PID],
                'ctime': item[CTIME],
                'size': item[PRODUCT].attributes.amount,
                'subscription': item[AUTO],
                'free': item[PRODUCT].free(),
                'removes': item.get(DELETETIME),
                'notified': item.get(NOTIFIED),
                'order': item.get(ORDER),
                'names': item[PRODUCT].get_names(auto=item[AUTO]),
            }

            if item.get(GROUP):
                formatted_item['group'] = item[GROUP]

            if item.get(GROUP) and item.get(CHILD_SIDS):
                formatted_item['paid_for_other'] = True

            result.append(formatted_item)

        return self.to_json(result)

    def service_prolongate(self, **kw):
        return self.to_json({'number': self.request.data['result']})

    def service_unsubscribe(self, **kw):
        return self.default_success()

    def service_set_attribute(self, **kw):
        return self.default_success()

    def service_remove_attribute(self, **kw):
        return self.default_success()


def format_service_data(service_data):
    """
    Приводит словарь услуги к виду, в котором отдается наружу

    Существует старый привычный формат ответа ручки 'service_list'. Также существуют другие ручки, в которых необходимо
    возвращать информацию по сервисам в таком же виде. Для этих целей заведен этот метод, в котором происходит общая
    обработка.
    """
    formatted_data = {
        'sid': service_data[SID],
        'name': service_data[PID],
        'ctime': service_data[CTIME],
        'expires': service_data[BTIME],
        'size': service_data[PRODUCT].attributes.amount,
        'subscription': service_data[AUTO],
        'state': service_data[STATE],
        'free': service_data[PRODUCT].free(),
        'removes': service_data.get(DELETETIME),
        'order': service_data.get(ORDER),
        'names': service_data[PRODUCT].get_names(auto=service_data[AUTO]),
    }

    if service_data.get(PAYMETHOD):
        formatted_data[PAYMETHOD] = service_data[PAYMETHOD]

    if service_data.get(GROUP):
        formatted_data['group'] = service_data[GROUP]

    if service_data.get(GROUP) and service_data.get(CHILD_SIDS):
        formatted_data['paid_for_other'] = True

    if service_data.get(GROUP_UIDS):
        formatted_data['group_uids'] = service_data[GROUP_UIDS]

    if service_data.get(BUYER_UID):
        formatted_data['buyer_uid'] = service_data[BUYER_UID]

    if service_data.get(GROUP_NAME):
        formatted_data['group_name'] = service_data[GROUP_NAME]

    return formatted_data
