# -*- coding: utf-8 -*-
from mpfs.frontend.formatter.disk.json import JSON


class Photoslice(JSON):
    content_type = 'application/json; charset=utf-8'

    def resources(self, **kw):
        """
        Форматирование списка ресурсов фотосреза

        Если у нас заглушка вместо ресурса, то оставляем ее как есть
        В случае нормального ресурса делаем ему стандартное форматирование
        См. https://st.yandex-team.ru/CHEMODAN-21299
        """
        data = self.data['result']

        formatted_list = []
        for item in data['list']:
            if isinstance(item, dict):
                formatted_list.append(item)
            else:
                formatted_list.append(self._file_element(item.form))

        data['list'] = formatted_list
        return self.to_json(data)