# -*- coding: utf-8 -*-

import re
import traceback
from lxml import etree

import mpfs.engine.process

from mpfs.common.static import messages
from mpfs.common.static import codes
from mpfs.common.static.tags import *
from mpfs.common import errors
from mpfs.frontend.formatter.util import *
from mpfs.common.util import filetypes
from mpfs.frontend.formatter.default_formatter import Default

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

class Invite(Default):

    def process(self, f, **kw):
        self.data = self.request.data
        response = getattr(self, f)(**kw)
        self.request.http_resp.headers['Content-Type'] = 'text/xml'
        return etree.tostring(response, pretty_print=True)
    
    def enqueue(self, **kw):
        data = self.data[RESULT]
        response = etree.Element(RESPONSE, status="1")
        return response
        
    def activate(self, **kw):
        data = self.data[RESULT]
        response = etree.Element(RESPONSE, status="1")
        return response
    
    def info(self, **kw):
        response = etree.Element(RESPONSE, status="1")
        self._set_text(etree.SubElement(response, USER_NAME), self.data[RESULT])
        return response
    
    def error(self, err):
        xmlObject, http_error_code = self.xml_error(err)
        self.request.http_resp.status = http_error_code
        return xmlObject
