# -*- coding: utf-8 -*-

import cjson

import mpfs.engine.process

from mpfs.common.static.tags import *
from mpfs.frontend.formatter.disk.json import JSON
from mpfs.common.util import to_json

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class Support(JSON):

    def block_public_file(self, **kw):
        return cjson.encode(self.data)

    def get_public_file_address(self, **kw):
        return cjson.encode(self.data)

    def get_moderation_list(self, **kw):
        return cjson.encode(self.data)

    def set_status(self, **kw):
        return cjson.encode(self.data)

    def get_comments(self, **kw):
        return cjson.encode(self.data[RESULT])

    def find_by_hash(self, **kw):
        return cjson.encode(self.data[RESULT])

    def block_user(self, **kw):
        return cjson.encode(self.data)

    def unblock_file(self, **kw):
        return cjson.encode(self.data)

    def unblock_user(self, **kw):
        return cjson.encode(self.data)

    def user_invite_sent(self, **kw):
        return cjson.encode(self.data[RESULT])

    def push_log(self, **kw):
        return cjson.encode(self.data)

    def user_info(self, **kw):
        return cjson.encode(self.data[RESULT])

    def user_invite_info(self, **kw):
        return cjson.encode(self.data[RESULT])

    def user_info_attributes(self, **kw):
        return cjson.encode(self.data[RESULT])

    def user_invite_activated(self, **kw):
        return cjson.encode(self.data[RESULT])

    def download_url(self, **kw):
        return cjson.encode(self.data[RESULT])

    def update_comment(self, **kw):
        return cjson.encode(self.data[RESULT])

    def trash_restore_all(self, **kw):
        return cjson.encode(self.data[RESULT])

    def is_single_owner(self, **kw):
        return cjson.encode(self.data[RESULT])

    def async_restore_deleted(self, **kw):
        return cjson.encode(self.data[RESULT])

    def fail_operations(self, **kw):
        return cjson.encode(self.data[RESULT])

    def block_zaberun_url(self, **kw):
        return cjson.encode(self.data[RESULT])
    
    def set_limit_by_services(self, **kw):
        return cjson.encode(self.data[RESULT])

    def uids_with_public_hids(self, **kw):
        return to_json(self.data[RESULT])

    def batch_block(self, **kw):
        return to_json(self.data[RESULT])

    def get_block_history(self, **kw):
        return to_json(self.data[RESULT])

    def async_block_uids_by_hid(self, **kw):
        return to_json(self.data[RESULT])
