# -*- coding: utf-8 -*-


import os
from lxml import etree


sep = os.path.sep


def split_path(path, with_root=False):
    assert isinstance(path, (str, unicode))
    if path == sep:
        return [path]
    parts = filter(None, path.split(sep))
    if with_root:
        return [sep] + parts
    else:
        return parts

def split_file(path, name):
    assert isinstance(path, (str, unicode))
    parts = filter(None, path.split(sep))
    return parts[:-1] + [name], parts[-1:][0]


def drweb_status(status):
    states = {0 : None, 1 : '<ok/>', 2 : '<infected/>'}
    return states.get(status)

