# -*- coding: utf-8 -*-
"""

MPFS
INVITE

"""
import mpfs.engine.process

from mpfs.invite import manager

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

def enqueue(req):
    '''
    Поместить в очередь email
    '''
    manager.push_email(req.project, req.address, **req.info)
    return True
    
    
def activate(req):
    '''
    Активировать код 
    '''
    manager.activate_code(req.project, req.code, req.uid, **req.info)
    return True


def info(req):
    '''
    Выдать информацию по пользователю, выдавшему инвайт
    '''
    return manager.code_info(req.project, req.code)
