# -*- coding: utf-8 -*-
"""

MPFS
INVITE

Исключения

"""
from mpfs.common.static import codes as common_codes
from mpfs.common.static import messages as common_messages
from mpfs.common.errors import MPFSRootException

class InviteError(MPFSRootException):
    response = common_messages.default_response

    def __init__(self, *args, **kwargs):
        super(InviteError, self).__init__(*args, **kwargs)
        self.message = self.message + self.extra_msg

codes = (
    INVITE_NOT_FOUND,
    INVITE_ACTIVATED,
    INVITE_BLOCKED,
    INVITE_RESERVED,
    CONTACT_NOT_FOUND,
    CONTACT_ALREADY_EXIST,
    CONTACT_INVALID,
    CONTACT_NOT_NEW,
    CONTACT_NOT_SERVED,
    INVITE_HAS_NO_OWNER,
    USER_ALREADY_EXISTS,
    USER_ALREADY_HAVE_DISK,
) = xrange(12)

class InviteNotFound(InviteError):
    code = INVITE_NOT_FOUND
    message = 'invite not found'
    response = 404
    
class InviteActivated(InviteError):
    code = INVITE_ACTIVATED
    message = 'invite activated'
    response = 409

class InviteBlocked(InviteError):
    code = INVITE_BLOCKED
    message = 'invite blocked'
    response = 409
    
class InviteReserved(InviteError):
    code = INVITE_RESERVED
    message = 'invite reserved'
    response = 409
    
class InviteHasNoOwner(InviteError):
    code = INVITE_HAS_NO_OWNER
    message = 'invite has no owner'
    response = 404

class ContactNotFound(InviteError):
    code = CONTACT_NOT_FOUND
    message = 'contact not found'
    response = 404
    
class ContactAlreadyExist(InviteError):
    code = CONTACT_ALREADY_EXIST
    message = 'contact already exist'
    response = 409
    
class ContactInvalid(InviteError):
    code = CONTACT_INVALID
    message = 'invalid contact'
    response = 400
    
class ContactArchivatedOrBlocked(InviteError):
    code = CONTACT_NOT_NEW
    message = 'cannot use contact, its blocked or archivated'
    response = 409
    
class ContactNotServed(InviteError):
    code = CONTACT_NOT_SERVED
    message = 'email is from MFD!'
    response = 409
    
class UserAlreadyExists(InviteError):
    code = USER_ALREADY_EXISTS
    message = 'user already exists'
    response = 409

class UserAlreadyHaveDisk(InviteError):
    code = USER_ALREADY_HAVE_DISK
    message = 'invited user already have disk'
    response = 409