# -*- coding: utf-8 -*-
from mpfs.core.event_dispatcher.events import Event


class InviteEvent(Event):
    """Базовое событие инвайтов"""
    required_fields = (('uid', (basestring, long)),
                       ('project', basestring))


class InviteSentEvent(InviteEvent):
    """Событие отправки инвайта на почту"""
    required_fields = (('address', basestring),
                       ('provider', basestring))


class InviteActivationEvent(InviteEvent):
    """Событие активации инвайта"""
    required_fields = (('owner_uid', (type(None), basestring)),)
