# -*- coding: utf-8 -*-

# Сортировка по возрастанию
ASCENDING = 1
# Сортировка по убыванию
DESCENDING = -1


class Document(object):
    def __init__(self, *args, **kwargs):
        self.data = None
        self.version = None
        self.key = None
        self.uid = None
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def __str__(self, *args, **kwargs):
        obj = super(Document, self).__str__(*args, **kwargs)
        return '\n%s\nuid: %s\nkey: %s\nversion: %s\ndata: %s' % (obj, self.uid, self.key, self.version, self.data)


class MResponse(object):
    def __init__(self, *args, **kwargs):
        self.value = None
        self.version = None
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def __str__(self, *args, **kwargs):
        obj = super(MResponse, self).__str__(*args, **kwargs)
        return '\n%s\nversion: %s\nvalue: %s' % (obj, self.version, self.value)

    def ok(self):
        return self.value and self.value.data
