# -*- coding: utf-8 -*-
import click


@click.command('common_migrate', help=u"Мигратор коллекций из common mongo в postgres")
@click.option('-c', '--collection', help=u'Имя коллекции', required=True)
@click.option('-m', '--mode', type=click.Choice(['validate', 'real']), default='real',
              help=u'Режим работы мигратора:\n`validate` проверяет соответствие данных\n'
              u'`real` мигрирует данные и проверяет соответствие их количества в mongo и pg')
@click.option('-s', '--skip', help=u'Сколько записей пропустить', default=0)
@click.option('-l', '--limit', help=u'Сколько записей смигрировать', default=0)
@click.option('--validate/--no-validate', help=u'Валидировать в процессе (не нужно, если частями)', default=True)
def common_migrate(collection, mode, skip, limit, validate):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.dao.migration.manager import CommonMigrationManager
    from mpfs.dao.migration.migration import MigrationMode

    common_migration_manager = CommonMigrationManager(mode=MigrationMode(mode))
    common_migration_manager.run(collection, skip=skip, limit=limit, validate=validate)
