# -*- coding: utf-8 -*-
"""

Чейжнлог
TODO: принести версионный diff сюда

"""
import operator

from itertools import ifilter, imap, groupby
import datetime

import mpfs.engine.process

from mpfs.common.errors.share import GroupNotFound
from mpfs.metastorage.mongo.util import *
from mpfs.metastorage.mongo.collections.base import UserIndexCollection, BaseCollection

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
requests_log = mpfs.engine.process.get_requests_log()


class ChangelogCollection(BaseCollection):
    name = 'changelog'
    is_sharded = True
    is_common = False

    def count(self, *args, **kwargs):
        return self.db[self.name].find(*args, **kwargs).count()

    def find(self, *args, **kwargs):
        return self.db[self.name].find(*args, **kwargs)

    def find_one(self, *args, **kwargs):
        return self.db[self.name].find_one(*args, **kwargs)

    def remove_by_uid(self, uid):
        if not uid:
            raise ValueError('uid is empty')
        self.db[self.name].remove({'uid': uid}, multi=True)

    def create_version(self, uid, key, op, ver, res_type, group_version=True, **rawdata):
        uid = propper_uid(uid)
        key = propper_key(key)
        rawdata.update({
            'op'      : op,
            'type'    : res_type,
            'key'     : key,
        })

        data = {
            'uid': uid,
            'version': ver,
            'zdata': compress_data(rawdata),
            'dtime':  datetime.datetime.now()
        }

        links = None
        if mpfs.engine.process.use_shared_folders() and group_version:
            from mpfs.core.social.share import Group
            try:
                group = Group.find(uid=uid, path=key, group=True, link=False)
            except GroupNotFound:
                pass
            else:
                if group.path != key:
                    data['gid'] = group.gid
                    data['group_path'] = group.path
                    links = group.iterlinks()

        self.db[self.name].insert(data, **self._fsync_safe_w())
        self.update_user_disk_version(uid, ver)

        if links:
            for link in links:
                self.update_user_disk_version(link.uid, ver)

    @staticmethod
    def update_user_disk_version(uid, version):
        user_index = UserIndexCollection()

        doc = {'$set': {'version': version}}
        spec = {
            '_id': uid,
            'shard_key': shard_key(uid),
            '$or': [
                {'version': {'$lt': version}},
                {'version': {'$exists': False}},
            ],
        }
        user_index.update(spec, doc)

    def shared_folder_action(self, uid, key, rawdata, rights, who, op='changed'):
        user_index = UserIndexCollection()
        uid = propper_uid(uid)
        key = propper_key(key)
        ver = generate_version_number()
        folder_data = {
                       'visible' : int(rawdata.get('visible', 1) or 1),
                       'fid' : rawdata['meta'].get('file_id'),
                       }
        data = {
                'op'      : op,
                'type'    : 'dir',
                'uid'     : uid,
                'key' : key,
                'version' : ver,
                'rights' : rights,
                'shared' : who,
                'zdata' : compress_data(folder_data),
                }
        self.db[self.name].insert(data, **self._fsync_safe_w())
        spec = {'_id' : uid, 'shard_key' : shard_key(uid)}
        doc = {'$set' : {'version' : ver}}
        user_index.update(spec, doc)
        return ver

    def owners_folder_created(self, uid, key, rawdata, rights):
        return self.shared_folder_action(uid, key, rawdata, rights, 'owner')

    def users_folder_created(self, uid, key, rawdata, rights):
        return self.shared_folder_action(uid, key, rawdata, rights, 'group', 'new')

    def users_folder_updated(self, uid, key, rawdata, rights):
        return self.shared_folder_action(uid, key, rawdata, rights, 'group')

    def folder_unshared(self, uid, key, rawdata, rights):
        return self.shared_folder_action(uid, key, rawdata, rights, 'unshared')
