# -*- coding: utf-8 -*-
"""
Содержит коллекции, необходимые для чистки стораджа и hidden_data
"""
from pymongo import ReadPreference

from mpfs.config import settings
from mpfs.metastorage.mongo.collections.base import DirectRouteCollection


MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_PRIMARY_READ_PREFERENCE = \
    settings.mongo['options']['counters_collection_options']['enable_primary_read_preference']
MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_WRITE_CONCERN = \
    settings.mongo['options']['counters_collection_options']['enable_write_concern']
MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_WRITE_TIMEOUT = \
    settings.mongo['options']['counters_collection_options']['write_timeout']


class DeletedStidsCollection(DirectRouteCollection):
    """Содержит stid-ы, отправляемые на проверку"""
    CONNECTION_NAME = 'common3'
    DB_COLL_NAME = 'deleted_stids'


class DeletedStidsRetryRemoveCollection(DirectRouteCollection):
    """Содержит stid-ы, отправляемые на чистку повторно"""
    CONNECTION_NAME = 'common3'
    DB_COLL_NAME = 'deleted_stids_retry_remove'


class StorageCleanCheckStidsCollection(DirectRouteCollection):
    """Необходима для локов"""
    CONNECTION_NAME = 'common3'
    DB_COLL_NAME = 'storage_clean_check_stids'

    @property
    def collection(self):
        collection = super(StorageCleanCheckStidsCollection, self).collection

        # Для pymongo3:
        # options = {}
        # if MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_PRIMARY_READ_PREFERENCE:
        #     options['read_preference'] = ReadPreference.PRIMARY
        # if MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_WRITE_CONCERN:
        #     options['write_concern'] = WriteConcern(w=2,
        #                                             wtimeout=MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_WRITE_TIMEOUT)
        #
        # if options:
        #     return collection.with_options(**options)
        # else:
        #     return collection

        return collection

    def _get_write_concern_options(self):
        options = {}
        if MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_WRITE_CONCERN:
            options['w'] = 2
            options['wtimeout'] = MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_WRITE_TIMEOUT
        return options

    def _get_read_preferences_options(self):
        options = {}
        if MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_PRIMARY_READ_PREFERENCE:
            options['read_preference'] = ReadPreference.PRIMARY
        return options

    def _fsync_safe_w(self):
        if MONGO_OPTIONS_COUNTERS_COLLECTION_OPTIONS_ENABLE_WRITE_CONCERN:
            return {}
        else:
            return super(StorageCleanCheckStidsCollection, self)._fsync_safe_w()

    def update(self, *args, **kwargs):
        kwargs.update(self._get_write_concern_options())
        return super(StorageCleanCheckStidsCollection, self).update(*args, **kwargs)

    def insert(self, *args, **kwargs):
        kwargs.update(self._get_write_concern_options())
        return super(StorageCleanCheckStidsCollection, self).insert(*args, **kwargs)

    def find(self, *args, **kwargs):
        kwargs.update(self._get_read_preferences_options())
        return super(StorageCleanCheckStidsCollection, self).find(*args, **kwargs)
