# -*- coding: utf-8 -*-
"""

Инвайт и прочая мутота

"""
import copy
import operator


from mpfs.metastorage.mongo.util import *
from mpfs.metastorage import MResponse, Document
from mpfs.metastorage.mongo.collections.base import ShardedById, KeyValue, DiskCollection
from mpfs.common import errors


class NewInviteMpfsCollection(ShardedById):
    is_sharded = False
    is_common = True

    def put(self, uid, key, rawdata, version, **kwargs):
        data = {
            '_id'    : key,
            'version': generate_version_number(),
            'data'   : rawdata,
        }

        return self.db[self.name].insert(data,  **self._fsync_safe_w())

    def show(self, uid, key, version=None):
        resource = self.db[self.name].find_one({'_id':key})
        
        if not resource:
            return MResponse(value=None, version=None)
        else:
            ver = str(resource.get('version', generate_version_number()))
            result = {
                '_id'     : resource['_id'],
                'uid'     : uid, 
                'version' : ver, 
                'data'    : resource['data'],
            }
                
            return MResponse(value=Document(**result), version=str(ver))
    
    def remove(self, uid, key, old_version, new_version=None):
        self.db[self.name].remove({'_id':key}, **self._fsync_safe_w())

    def find(self, uid, folder, common_args, meta_args, sort_field, maxresults):
        query = {}
        for k in common_args:
            if isinstance(common_args[k], (list, tuple)):
                common_args[k] = {'$in' : list(common_args[k])}
        for k in meta_args:
            if isinstance(meta_args[k], (list, tuple)):
                meta_args[k] = {'$in' : list(meta_args[k])}
                
        query.update(('data.%s' % k, v) for k, v in common_args.iteritems())
        query.update(('data.meta.%s' % k, v) for k, v in meta_args.iteritems())
        sort_field = 'data.%s' % sort_field
        
        if maxresults:
            response = self.db[self.name].find(query).sort(sort_field).limit(maxresults)
        else:
            response = self.db[self.name].find(query).sort(sort_field)
        
        return map(operator.itemgetter('data'), response)


class OldInviteMpfsCollection(NewInviteMpfsCollection):
    is_sharded = False
    is_common = True
    
    def put(self, key, rawdata, version=None, **kwargs):
        data = {
            '_id'    : key,
            'version': generate_version_number(),
            'data'   : rawdata,
        }
        
        return self.db[self.name].insert(data, **self._fsync_safe_w())

    def update(self, key, rawdata, version=None, **kwargs):
        query = {
            '_id': key
        }
        data = {
            'version': generate_version_number(),
            'data': rawdata,
        }
        return self.db[self.name].update(query, data, **self._fsync_safe_w())

    def show(self, key, version=None):
        result = self.db[self.name].find_one({'_id' : key})
        if result:
            return MResponse(value=Document(**result), version=str(result['version']))    
        else:
            return MResponse(value=None, result=None)
        
    def remove(self, key, old_version=None, new_version=None):
        self.db[self.name].remove({'_id':key}, **self._fsync_safe_w())


class InviteMpfsCodesCollection(OldInviteMpfsCollection):
    name = 'invite_mpfs_codes'
    is_sharded = False
    is_common = True
    
   
class InviteMpfsContactsCollection(OldInviteMpfsCollection):
    name = 'invite_mpfs_contacts'
    is_sharded = False
    is_common = True
    
    
class InviteMpfsReferralsCollection(DiskCollection):
    name = 'invite_mpfs_referrals'
    is_sharded = False
    is_common = True
    uid_field = 'ref'
    
    def put(self, uid, rawdata, version=None, **kwargs):
        rawdata['_id'] = uid
        self.db[self.name].insert(rawdata, **self._fsync_safe_w())

    def show(self, uid, key=None, version=None):
        return self.db[self.name].find_one({'_id': uid})

    def folder_counters(self, uid, key=None, version=None):
        return self.db[self.name].find({'ref': uid}).count()

    def folder_content(self, uid, key=None, version=None, filter_args={}, range_args={}):
        return self.db[self.name].find({'ref': uid})

    def update_where(self, uid, new_value, old_value, old_version=None):
        query = copy.deepcopy(old_value)
        update = {"$set" : copy.deepcopy(new_value)}
        if self.db[self.name].update(query, update, **self._fsync_safe_w()):
            return MResponse(value=True, version='')
        else:
            raise errors.StorageUpdateWhereFailed()

    def remove_domain(self, uid):
        uid = propper_uid(uid)
        self.db[self.name].remove({'_id': uid}, **self._fsync_safe_w())
        return True
    

class InviteMpfsSent(KeyValue):
    name = 'invite_mpfs_sent'
    key_fields = ('uid', 'p', 'u')
    is_sharded = False
    is_common = True