# -*- coding: utf-8 -*-
"""

Метаданные по всем коллекциям

sharded = шардирована
uid_field = поле, в котором живет uid
name = имя в БД

"""
import pkgutil
import inspect

from mpfs.common.util import Singleton


class MPFSMongoCollectionsMeta(Singleton):
    
    __sharded_collections = set()
    __common_collections = set()
    __uid_field_mapper = {}
    __all_collections = {}

    def setup(self):
        from mpfs.metastorage.mongo import collections
        from mpfs.metastorage.mongo.collections.base import BaseCollection
    
        for _, name, is_package in pkgutil.iter_modules(collections.__path__):
            if not is_package:
                module_name = 'mpfs.metastorage.mongo.collections.' + name
                hm = __import__(module_name, fromlist=name)
                
                def check_class(cls):
                    try:
                        result = issubclass(cls, BaseCollection) and cls.name
                    except (TypeError, AttributeError):
                        result = False
                    return result
                
                for _, cls in filter(
                    lambda (c_name, c): check_class(c),
                    inspect.getmembers(hm, inspect.isclass)
                ):
                    if cls.is_sharded:
                        self.__sharded_collections.add(cls.name)
                    elif cls.is_common:
                        self.__common_collections.add(cls.name)
                    self.__uid_field_mapper[cls.name] = cls.uid_field
                    self.__all_collections[cls.name] = cls
                 
                globals().update(hm.__dict__)
                         
    def is_sharded(self, cname):
        return cname in self.__sharded_collections

    def is_common(self, cname):
        return cname in self.__common_collections
    
    def get_uid_field(self, cname):
        return self.__uid_field_mapper[cname]
    
    def get_sharded_collections(self):
        return self.__sharded_collections

    def get_common_collections(self):
        return self.__common_collections
    
    def get_collection_by_name(self, cname):
        return self.__all_collections.get(cname)()