# -*- coding: utf-8 -*-
"""

Коллекция операций 

"""
import copy

from datetime import datetime

from mpfs.engine.process import usrctl

from mpfs.config import settings
from mpfs.metastorage.mongo.util import *
from mpfs.metastorage import MResponse, Document
from mpfs.metastorage.mongo.collections.base import UserCollection

OPERATIONS_ZIP_DATA = settings.operations['zip_data']


class OperationsCollection(UserCollection):

    name = 'operations'
    is_sharded = True
    is_common = False

    @staticmethod
    def _process_doc(doc):
        """
        Внимание, меняет оригинальный документ
        """
        if not isinstance(doc['data'], dict):
            doc['data'] = decompress_data(doc['data'])
            if not isinstance(doc['data'], dict):
                raise TypeError("Operation `doc.data` field should be `dict`")
        doc['data']['id'] = doc['_id']
        doc['data']['state'] = doc['state']
        doc['data']['mtime'] = doc['mtime']
        doc['data']['dtime'] = doc['dtime']
        doc['data']['uid'] = doc['uid']
        doc['data']['md5'] = doc.get('md5', '')
        return doc

    def find(self, uid, key, query_args, data_args, maxresult, sort_field):
        uid = propper_uid(uid)
        query = self.query_for_find(uid=uid)
        for arg in query_args.iterkeys():
            if isinstance(query_args[arg], list):
                query[arg] = {'$in': query_args[arg]}
            else:
                query[arg] = query_args[arg]

        result = []
        for item in self.db[self.name].find(query):
            item_data = self._process_doc(item)['data']
            result.append(item_data)
        return result

    def show(self, uid, key, version=None):
        uid = propper_uid(uid)
        key = self._propper_key(key)
        query = self.query_for_show(uid, key)
        usrctl().assert_user_init(uid)
        ver = self.get_version(uid)
        resource = self.db[self.name].find_one(query)

        if not resource:
            return MResponse(value=None, version=None)

        resource = self._process_doc(resource)
        result = {
            'data'    : resource['data'],
            'version' : str(resource.get('version', generate_version_number())),
            'key'     : key,
            'uid'     : uid, 
            'type' : resource.get('type'),
        }

        return MResponse(value=Document(**result), version=str(ver))

    def remove(self, uid, key, old_version=None, new_version=None):
        return self.db[self.name].remove({'_id' : key, 'uid' : uid}, **self._fsync_safe_w())

    def query_for_show(self, uid, key):
        return {'_id' : key, 'uid': uid}

    def data_for_save(self, uid, key, rawdata, old_version, new_version, rtype):
        rawdata = copy.deepcopy(rawdata)
        state = rawdata.pop('state')
        mtime = rawdata.pop('mtime')
        ycrid = rawdata.pop('ycrid')
        type = rawdata['type']
        subtype = rawdata['subtype']
        rawdata.pop('uid')
        data = {'_id': key,
                'uid': uid,
                'state': state,
                'mtime': mtime,
                'data': compress_data(rawdata) if OPERATIONS_ZIP_DATA else rawdata,
                'version' : new_version,
                'ycrid': ycrid,
                'type': type,
                'subtype': subtype,
                }
        uniq_id = rawdata.get('uniq_id', '')
        md5 = rawdata['data'].get('md5', '')
        if md5:
            data['md5'] = md5
        if uniq_id:
            data['uniq_id'] = uniq_id
        data['dtime'] = datetime.utcnow()
        query = {'_id' : key, 'uid' : uid}

        return data, query

    def assert_parent(self, uid, key):
        return

    def _propper_key(self, key):
        return key
