# -*- coding: utf-8 -*-
"""

Теги и иже с ними
OLD MAMMOTH SHIT

"""
from datetime import datetime, timedelta
from itertools import imap
from collections import defaultdict

import mpfs.engine.process

from mpfs.common.util import hashed, fulltime, natsort, is_jpg, convert_gps_deg_dec
from mpfs.metastorage.mongo.util import *
from mpfs.metastorage.mongo.collections.base import BaseCollection
from mpfs.metastorage.mongo.collections.filesystem import UserDataCollection

# OLD MAMMOTH SHIT.
# вынесено из конфига.
# смотри релиз 2.21
tags_conf = {
    'tags_images': {
        'tags': ['gps', 'camera'],
        'fields': {
            'day': 'datetime.d',
            'month': 'datetime.m',
            'year': 'datetime.Y',
        },
    },
}

SYSTEM_TAGS_COLLECTIONS = {}
SYSTEM_TAGS_FIELDS = defaultdict(dict)
for collection, data in tags_conf.iteritems():
    for tag in data['tags']:
        SYSTEM_TAGS_COLLECTIONS[tag] = collection
    for tag, field in data['fields'].iteritems():
        SYSTEM_TAGS_FIELDS[collection][tag] = field


class TagCollection(BaseCollection):
    name = 'tags'
    is_sharded = True
    is_common = False

    def put(self, uid, file_id, scope, data):
        method = getattr(self, 'put_in_%s' % scope)
        method(uid, file_id, data)

    def put_in_system(self, uid, file_id, data):
        collections = defaultdict(dict)
        for tag, value in data.iteritems():
            try:
                collection_name = SYSTEM_TAGS_COLLECTIONS[tag]
            except KeyError:
                #TODO: создать новую ошибку
                raise Exception()
            else:
                if tag in SYSTEM_TAGS_FIELDS[collection_name]:
                    tag = SYSTEM_TAGS_FIELDS[collection_name][tag]
                collections[collection_name][tag] = value
        for collection, doc in collections.iteritems():
            new_version = generate_version_number()
            spec = {
                    '_id' : file_id,
                    'uid' : uid,
                    }
            data['v'] = new_version
            self.db[collection_name].update(spec, {'$set' : doc},
                                            upsert=True, **self._fsync_safe_w())

    def put_in_user(self, uid, file_id, data):
        for k,v in data.iteritems():
            spec = {
                    'uid' : uid,
                    'tag' : k,
                    }
            if v:
                spec['value'] = v
            tag = self.collection.find_one(spec)
            new_version = generate_version_number()
            if tag:
                tag_id = tag['_id']
            else:
                spec = {
                        'uid' : uid,
                        'tag' : k,
                        }
                if v:
                    spec['value'] = v
                document = {
                            '$set' : {
                                      'v' : new_version,
                                      },
                            }
                self.collection.update(spec, document, upsert=True, **self._fsync_safe_w())
                tag_id = self.collection.find_one(spec)['_id']
            spec = {
                    '_id' : id_for_key(str(tag_id), file_id),
                    'uid' : uid,
                    }
            document = {
                        '$set' : {
                                  'file_id' : file_id,
                                  'tag_id' : tag_id,
                                  'v' : new_version,
                                  }
                        }
            self.db['tag_resource'].update(spec, document, upsert=True, **self._fsync_safe_w())

    def get_elements_by_tag(self, uid, path, data):
        user_data = UserDataCollection()
        file_ids = []
        for tag, value in data.iteritems():
            spec = {
                    'uid' : uid,
                    'tag' : tag,
                    }
            if value:
                spec['value'] = value
            tag_object = self.collection.find_one(spec)
            if tag_object:
                spec = {
                        'uid' : uid,
                        'tag_id' : tag_object['_id'],
                        }
                for each in self.db['tag_resource'].find(spec):
                    file_ids.append(each['file_id'])
            else:
                continue
        if file_ids:
            spec = {
                    'uid' : uid,
                    'data.file_id' : {'$in' : file_ids},
                    }
            return list(user_data.find_by_field(uid, spec, ()))
        else:
            return []

    def get_tags_by_fid(self, uid, file_id):
        result = []
        spec = {
                'uid' : uid,
                'file_id' : file_id,
                }
        tag_ids = []
        for each in self.db['tag_resource'].find(spec):
            tag_ids.append(each['tag_id'])
        if tag_ids:
            spec = {
                    '_id' : {'$in' : tag_ids},
                    'uid' : each['uid'],
                    }
            for tag in self.collection.find(spec):
                result.append((tag['tag'], tag['value']))
        return result

    def _get_tag_ids_by_file_ids(self, uid, file_ids):
        if file_ids:
            result = []
            tag_ids = set()
            spec = {
                    'uid' : uid, 
                    'file_id' : {'$in' : file_ids},
                    }
            for each in self.db['tag_resource'].find(spec):
                tag_ids.add(each['tag_id'])
            if tag_ids:
                spec = {
                        'uid' : uid,
                        '_id' : {'$in' : list(tag_ids)},
                        }
                for tag in self.collection.find(spec):
                    result.append((tag['tag'], tag['value']))
            return result
        else:
            return []

    def _filter_files_by_user_tags(self, uid, files, user_tags):
        tag_ids = self._get_tag_ids(uid, user_tags)
        result = []
        spec = {
            'uid': uid,
            'file_id': {'$in': filter(lambda x: x['_id'], files)},
            'tag_id': {'$in': tag_ids},
        }
        filtered = set([f['file_id'] for f in self.db['tag_resource'].find(spec)])
        for f in files:
            if f['_id'] in filtered:
                result.append(f)
        return result


    def get_tags_in_folder_list(self, uid, path):
        user_data = UserDataCollection()
        args = {
                'uid' : uid,
                'parent' : id_for_key(uid, path),
                }
        file_ids = []
        for each in user_data.get_all(**args):
            file_id = each['data'].get('file_id')
            if file_id:
                file_ids.append(file_id)
        return self._get_tag_ids_by_file_ids(uid, file_ids)

    def _get_folder_tree(self, uid, key, body=False):
        user_data = UserDataCollection()
        parents = [id_for_key(uid, key), ]
        result = []
        while parents:
            parent = parents.pop()
            args = {
                    'uid' : uid,
                    'parent' : parent,
                    }
            for each in user_data.get_all(**args):
                element_type = each['type']
                if element_type == 'dir':
                    parents.append(each['_id'])
                file_id = each['data'].get('file_id')
                if file_id:
                    if body:
                        each['data'] = user_data._unzip_resource_data(element_type,
                                                                 each.pop('data', {}),
                                                                 each.pop('zdata', {}))
                        result.append(each)
                    else:
                        result.append(file_id)
        return result

    def get_tags_in_folder_tree(self, uid, path):
        return self._get_tag_ids_by_file_ids(uid, self._get_folder_tree(uid, path))

    def _get_tag_ids(self, uid, data):
        return list(self._iter_tag_ids(uid, data))

    def _iter_tag_ids(self, uid, data):
        spec = {
                'uid' : uid,
                '$or' : [],
                }
        for each in data:
            if isinstance(each, (list, tuple)):
                tag, value = each
                spec['$or'].append({'tag': tag, 'value' : value})
            else:
                spec['$or'].append({'tag': each})
        if spec['$or']:
            for each in self.collection.find(spec, fields=()):
                yield each['_id']

    def _iter_file_ids_by_tag_ids(self, uid, tag_ids):
        spec = {
            'uid': uid,
            'tag_id': {'$in': tag_ids},
        }
        for each in self.db['tag_resource'].find(spec, fields=()):
            yield each['file_id']

    def get_elements_in_folder_list(self, uid, path, data):
        user_data = UserDataCollection()
        tags_number = len(data)
        found_tags = self._get_tag_ids(uid, data)
        found_tags_length = len(found_tags)
        if found_tags_length == 0 or found_tags_length != tags_number:
            return []
        else:
            result = []
            args = {
                    'uid' : uid,
                    'parent' : id_for_key(uid, path),
                    }
            for resource in user_data.get_all(**args):
                file_id = resource['data'].get('file_id')
                if file_id:
                    spec = {
                            'uid': uid,
                            '_id' : {'$in' : []}
                            }
                    for tag_id in found_tags:
                        spec['_id']['$in'].append(id_for_key(str(tag_id), file_id))
                    if self.db['tag_resource'].find(spec).count() == tags_number:
                        resource['data'] = user_data._unzip_resource_data(resource['type'],
                                                                          resource.pop('data', {}),
                                                                          resource.pop('zdata', {}))
                        result.append(resource)
            return result

    def get_elements_in_folder_tree(self, uid, path, data):
        tags_number = len(data)
        found_tags = self._get_tag_ids(uid, data)
        found_tags_length = len(found_tags)
        if found_tags_length == 0 or found_tags_length != tags_number:
            return []
        else:
            result = []
            for resource in self._get_folder_tree(uid, path, body=True):
                spec = {
                        'uid': uid,
                        '_id' : {'$in' : []}
                        }
                file_id = resource['data']['meta']['file_id']
                for tag_id in found_tags:
                    spec['_id']['$in'].append(id_for_key(str(tag_id), file_id))
                if self.db['tag_resource'].find(spec).count() == tags_number:
                    result.append(resource)
            return result

    def tags_photo_timeline(self, uid, system_tags, user_tags):
        """

        Количество фотографий в каждом месяце.
        """
        user_data = UserDataCollection()
        collections = defaultdict(dict)
        folders = []
        for tag, value in system_tags.iteritems():
            if tag == 'folders':
                # TODO: Добавить обработку общих папок
                folders = map(lambda path: id_for_key(uid, path), value)
            else:
                try:
                    collection_name = SYSTEM_TAGS_COLLECTIONS[tag]
                except KeyError:
                    #TODO: создать новую ошибку
                    raise Exception()
                else:
                    collections[collection_name][SYSTEM_TAGS_FIELDS[collection_name][tag]] = value

        spec = {
            'uid' : uid,
        }
        if collections:
            result = []
            for collection_name, spec in collections.iteritems():
                spec['uid'] = uid
                if result:
                    spec['_id'] = map(lambda x: x['_id'], result)
                result = self.db[collection_name].find(spec)
                if not result:
                    return {}
        else:
            result = self.db['tags_images'].find(spec)

        if user_tags:
            filtered_files = {}
            user_tag_ids = self._get_tag_ids(uid, user_tags)
            user_tags_count = len(user_tag_ids)
            if user_tags_count != len(user_tags):
                return {}
            else:
                for each in result:
                    spec = {'uid': uid,
                            '_id': {}
                            }
                    spec['_id']['$in'] = map(lambda tag_id: id_for_key(str(tag_id), each['_id']), user_tag_ids)
                    tags_count = self.db['tag_resource'].find(spec).count()
                    if tags_count == user_tags_count:
                        filtered_files[each['file_id']] = each
        else:
            filtered_files = dict((each['_id'], each) for each in result)

        if folders:
            spec = {
                'uid': uid,
                'parent': {'$nin': folders},
                'data.file_id': {'$in': map(lambda f: f['_id'], filtered_files)}
            }
            fields = ('data.file_id',)
            for each in user_data.iter_all(spec, fields):
                filtered_files.pop(each['data']['file_id'])
        files_by_date = defaultdict(lambda : defaultdict(int))
        for each in filtered_files.itervalues():
            datetime_block = each['datetime']
            files_by_date[datetime_block['Y']][datetime_block['m']] += 1
        return files_by_date

    def tags_photo_list(self, uid, filters, system_tags, user_tags):
        user_data = UserDataCollection()
        if user_tags:
            file_ids = list(self._iter_file_ids_by_tag_ids(self._iter_tag_ids(uid, user_tags)))
        else:
            file_ids = []
        general_spec = {}
        general_sort = [('datetime.ts', 1),]
        folders = []
        for k, v in system_tags.iteritems():
            if k == 'folders':
                # TODO: Добавить обработку общих папок
                folders = map(lambda path: id_for_key(uid, path), v)
            else:
                general_spec[SYSTEM_TAGS_FIELDS['tags_images'][k]] = v
        sorted_file_ids = []
        for year, month, skip, limit in filters:
            spec = {
                'uid': uid,
                'datetime.Y': year,
                'datetime.m': month,
            }
            spec.update(general_spec)
            if file_ids:
                spec['_id'] = {'$in': file_ids}
            sorted_file_ids.extend(imap(lambda x: x['_id'], self.db['tags_images'].find(spec, skip=skip, limit=limit,
                                                                               sort=general_sort)))
        spec = {
            'uid': uid,
            'data.file_id': {'$in': sorted_file_ids},
        }
        for element in user_data.iter_all(spec, sort=[('data.etime', 1),]):
            yield user_data.unpack_single_element(element)

    def tags_set_photo_file(self, uid, file_id, etime, camera, geo):
        spec_tag = {
            '_id': file_id,
            'uid': uid,
        }
        date = datetime.fromtimestamp(etime)
        date = {
            'ts': etime,
            'Y': date.year,
            'm': date.month,
            'd': date.day,
        }
        doc_tag = {
            '$set': {
                'v': generate_version_number(),
                'datetime': date,
            },
        }
        if geo:
            doc_tag['$set']['geo'] = geo
        if camera:
            doc_tag['$set']['camera'] = camera
        self.db['tags_images'].update(spec_tag, doc_tag, upsert=True, **self._fsync_safe_w())

    def tags_set_photo_all(self, uid):
        user_data = UserDataCollection()
        spec = {
            'uid': uid,
            'data.mt': 9,
        }
        files_count = user_data.count(**spec)
        processed_count = 0
        received = True
        limit = 1000
        fields = ('_id', 'key', 'hid', 'zdata', 'data', 'version')
        while processed_count < files_count and received:
            received = list(user_data.iter_all(spec, skip=processed_count, limit=limit, fields=fields))
            for element in received:
                processed_count += 1
                if not (is_jpg(element['data']['mimetype']) and 'etime' in element['data']):
                    continue
                if 'file_id' in element['data']:
                    file_id = element['data']['file_id']
                else:
                    # Перенос file_id из zdata в data
                    file_id = user_data.move_file_id(element['_id'], uid, element['version'], element['zdata'])
                self.tags_set_photo_file(uid, file_id, element['data']['etime'], {}, {})

    def tags_remove_single(self, uid, file_id):
        spec = {
            '_id': file_id,
            'uid': uid,
        }
        for collection_name in SYSTEM_TAGS_FIELDS:
            self.db[collection_name].remove(spec, **self._fsync_safe_w())
        spec = {
            'file_id': file_id,
            'uid': uid,
        }
        self.db['tag_resource'].remove(spec, **self._fsync_safe_w())


class TagsImagesCollection(TagCollection):
    name = 'tags_images'
    is_sharded = True
    is_common = False
    

class TagsResourceCollection(TagCollection):
    name = 'tag_resource'
    is_sharded = True
    is_common = False
