# -*- coding: utf-8 -*-
import pymongo

from mpfs.metastorage.mongo import database
from mpfs.metastorage.mongo.util import LazyDatabaseObject
from mpfs.metastorage.mongo.logging import log_request
from pymongo.errors import OperationFailure, AutoReconnect


class MPFSMongoConnection(pymongo.MongoClient):
    database_class = database.MPFSMongoDatabase

    def __init__(self, *args, **kwargs):
        self.__name = kwargs.pop('name', None)
        # pymongo3
        # kwargs['connect'] = False
        super(MPFSMongoConnection, self).__init__(*args, **kwargs)

    @log_request
    def _send_message(self, *args, **kwargs):
        try:
            return super(MPFSMongoConnection, self)._send_message(*args, **kwargs)
        except OperationFailure as e:
            self._handle_error(e)

    @log_request
    def _send_message_with_response(self, *args, **kwargs):
        try:
            return super(MPFSMongoConnection, self)._send_message_with_response(*args, **kwargs)
        except OperationFailure as e:
            self._handle_error(e)

    def _handle_error(self, e):
        s = unicode(e)
        if u'[SEND_ERROR]' in s:
            # treat such errors as permanent network failures:
            self.close()
            raise AutoReconnect(s.encode('utf-8'))
        raise

    @property
    def name(self):
        return self.__name

    def __getattr__(self, name):
        return self.database_class(self, name)

    def __getitem__(self, name):
        return self.database_class(self, name)


class MPFSMongoLazyConnectionProxy(LazyDatabaseObject):
    actual_class = MPFSMongoConnection
    database_class = database.MPFSMongoLazyDatabase
    attribute_class = database.MPFSMongoLazyDatabase
    singleton = False

    def __init__(self, *args, **kwargs):
        self.__name = kwargs.get('name', None)
        super(MPFSMongoLazyConnectionProxy, self).__init__(*args, **kwargs)

    def get_instance(self):
        return super(MPFSMongoLazyConnectionProxy, self).get_instance()

    def drop_database(self, name_or_database):
        self.get_instance().drop_database(name_or_database)

    @property
    def name(self):
        return self.__name
