# -*- coding: utf-8 -*-
import pymongo
import itertools

import mpfs.engine.process

from mpfs.config import settings

log = mpfs.engine.process.get_default_log()
requests_log = mpfs.engine.process.get_requests_log()


class MPFSCommonCursor(pymongo.collection.Cursor):
    def __init__(self, *args, **kwargs):
        super(MPFSCommonCursor, self).__init__(*args, **kwargs)

        if settings.mongo['options']['use_hints']:
            self.__apply_hints(*args)

    def __apply_hints(self, *args):
        """
        В рамках борьбы с кривым планировщиком запросов mongo вручную указываем
        индексы, по которым планировщик должен работать

        :param args: параметры запроса (объект коллекции, dict запроса)
        """
        if len(args) > 1 and isinstance(args[1], dict):
            hint = None
            if '_id' in args[1]:
                hint = [('_id', pymongo.ASCENDING)]
            elif 'uid' in args[1] and 'parent' in args[1]:
                hint = [('uid', pymongo.ASCENDING), ('parent', pymongo.ASCENDING)]

            if hint:
                self.hint(hint)

    '''
    Оставляем на будущее умный метод накладывания хинтов
    https://st.yandex-team.ru/CHEMODAN-21320

    def __apply_hints(self, *args):
        """
        В рамках борьбы с кривым планировщиком запросов mongo вручную указываем
        индексы, по которым планировщик должен работать

        :param args: параметры запроса (имя коллекции, dict запроса)
        """
        if len(args) > 1 and isinstance(args[1], dict):
            collection = args[0]
            try:
                indexes = collection.get_indexes()
                if '_id' in indexes and '_id' in args[1]:
                    self.hint([('_id', pymongo.ASCENDING)])
                elif 'uid' in args[1] and 'parent' in args[1] and 'uid_parent' in indexes:
                    self.hint([('uid', pymongo.ASCENDING), ('parent', pymongo.ASCENDING)])
                elif 'parent' in args[1] and 'parent' in indexes:
                    self.hint([('parent', pymongo.ASCENDING)])
            except TypeError:
                # при начальном старте системы используются обычные классы коллекций монги, в которых нет get_indexes
                # проще поймать ошибку, чем муторно обрабатывать поиск есть оно или нет
                pass
   '''
